/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.api;

import java.lang.reflect.Field;
import org.apache.log4j.Logger;
import org.red5.server.api.IBasicScope;
import org.red5.server.api.IContext;
import org.red5.server.api.IScope;
import org.red5.server.api.IScopeHandler;
import org.red5.server.api.IScopeService;
import org.springframework.context.ApplicationContext;

public class ScopeUtils {
    private static final Logger log = Logger.getLogger(ScopeUtils.class);
    private static final int GLOBAL = 0;
    private static final int APPLICATION = 1;
    private static final int ROOM = 2;
    private static final String SERVICE_CACHE_PREFIX = "__service_cache:";
    private static final String SLASH = "/";

    public static IScope resolveScope(IScope from, String path) {
        String[] parts;
        IScope current = from;
        if (path.startsWith(SLASH)) {
            current = ScopeUtils.findRoot(current);
            path = path.substring(1, path.length());
        }
        if (path.endsWith(SLASH)) {
            path = path.substring(0, path.length() - 1);
        }
        for (String part : parts = path.split(SLASH)) {
            if (part.equals(".")) continue;
            if (part.equals("..")) {
                if (!current.hasParent()) {
                    return null;
                }
                current = current.getParent();
                continue;
            }
            if (!current.hasChildScope(part)) {
                return null;
            }
            current = current.getScope(part);
        }
        return current;
    }

    public static IScope findRoot(IScope from) {
        IScope current = from;
        while (current.hasParent()) {
            current = current.getParent();
        }
        return current;
    }

    public static IScope findApplication(IScope from) {
        IScope current = from;
        while (current.hasParent() && current.getDepth() != 1) {
            current = current.getParent();
        }
        return current;
    }

    public static boolean isAncestor(IBasicScope from, IBasicScope ancestor) {
        IBasicScope current = from;
        while (current.hasParent()) {
            if (!(current = current.getParent()).equals(ancestor)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRoot(IBasicScope scope) {
        return !scope.hasParent();
    }

    public static boolean isGlobal(IBasicScope scope) {
        return scope.getDepth() == 0;
    }

    public static boolean isApp(IBasicScope scope) {
        return scope.getDepth() == 1;
    }

    public static boolean isRoom(IBasicScope scope) {
        return scope.getDepth() >= 2;
    }

    protected static Object getScopeService(IScope scope, String name) {
        return ScopeUtils.getScopeService(scope, name, null);
    }

    protected static Object getScopeService(IScope scope, String name, Class defaultClass) {
        Object result;
        if (scope == null) {
            return null;
        }
        IContext context = scope.getContext();
        ApplicationContext appCtx = context.getApplicationContext();
        if (!appCtx.containsBean(name)) {
            if (defaultClass == null) {
                return null;
            }
            try {
                result = defaultClass.newInstance();
            }
            catch (Exception e) {
                log.error((Object)e);
                return null;
            }
        } else {
            result = appCtx.getBean(name);
        }
        return result;
    }

    public static Object getScopeService(IScope scope, Class intf) {
        return ScopeUtils.getScopeService(scope, intf, null);
    }

    public static Object getScopeService(IScope scope, Class intf, boolean checkHandler) {
        return ScopeUtils.getScopeService(scope, intf, null, checkHandler);
    }

    public static Object getScopeService(IScope scope, Class intf, Class defaultClass) {
        return ScopeUtils.getScopeService(scope, intf, defaultClass, true);
    }

    public static Object getScopeService(IScope scope, Class intf, Class defaultClass, boolean checkHandler) {
        if (scope == null || intf == null) {
            return null;
        }
        assert (intf.isInterface());
        if (scope.hasAttribute("_transient__service_cache:" + intf.getCanonicalName())) {
            return scope.getAttribute("_transient__service_cache:" + intf.getCanonicalName());
        }
        Object handler = null;
        if (checkHandler) {
            for (IScope current = scope; current != null; current = current.getParent()) {
                IScopeHandler scopeHandler = current.getHandler();
                if (intf.isInstance(scopeHandler)) {
                    handler = scopeHandler;
                    break;
                }
                if (!current.hasParent()) break;
            }
        }
        if (handler == null && IScopeService.class.isAssignableFrom(intf)) {
            Field key = null;
            Object serviceName = null;
            try {
                key = intf.getField("BEAN_NAME");
                serviceName = key.get(null);
                if (!(serviceName instanceof String)) {
                    serviceName = null;
                }
            }
            catch (Exception e) {
                log.debug((Object)"No string field 'BEAN_NAME' in that interface");
            }
            if (serviceName != null) {
                handler = ScopeUtils.getScopeService(scope, (String)serviceName, defaultClass);
            }
        }
        if (handler == null && defaultClass != null) {
            try {
                handler = defaultClass.newInstance();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        scope.setAttribute("_transient__service_cache:" + intf.getCanonicalName(), handler);
        return handler;
    }
}

