/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.jboss;

import java.beans.Introspector;
import java.io.File;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.red5.server.jboss.JbossLoaderMBean;
import org.red5.server.jmx.JMXAgent;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class JbossLoader
implements ApplicationContextAware,
JbossLoaderMBean {
    protected static ThreadLocal<ApplicationContext> applicationContext = new ThreadLocal();
    protected static Logger logger = Logger.getLogger((String)JbossLoader.class.getName());

    public void start() {
        logger.info((Object)"Loading jboss service");
        System.setProperty("red5.deployment.type", "jboss");
        logger.info((Object)"RED5 Server (http://www.osflash.org/red5)");
        long time = System.currentTimeMillis();
        try {
            String root = System.getProperty("red5.root");
            logger.info((Object)("Red5 root: " + root));
            String configRoot = System.getProperty("red5.config_root");
            logger.info((Object)("Red5 config root: " + configRoot));
            String classpath = System.getProperty("java.class.path");
            System.setProperty("java.class.path", classpath + File.pathSeparatorChar + root + File.pathSeparatorChar + configRoot);
            logger.debug((Object)("Updated classpath: " + System.getProperty("java.class.path")));
            ClassPathXmlApplicationContext appCtx = new ClassPathXmlApplicationContext(configRoot + "beanRefContext.xml");
            this.setApplicationContext((ApplicationContext)appCtx);
        }
        catch (Exception e) {
            logger.error((Object)"Error during startup", (Throwable)e);
        }
        long startupIn = System.currentTimeMillis() - time;
        logger.info((Object)("Startup done in: " + startupIn + " ms"));
    }

    public boolean isStarted() {
        return true;
    }

    public void stop() {
        logger.info((Object)"Shutting down jboss context");
        try {
            Introspector.flushCaches();
            JMXAgent.shutdown();
            FileSystemXmlApplicationContext appContext = (FileSystemXmlApplicationContext)this.getApplicationContext();
            ConfigurableListableBeanFactory factory = appContext.getBeanFactory();
            if (factory.containsSingleton("default.context")) {
                for (String scope : factory.getRegisteredScopeNames()) {
                    logger.debug((Object)("Registered scope: " + scope));
                }
                for (String singleton : factory.getSingletonNames()) {
                    logger.debug((Object)("Registered singleton: " + singleton));
                }
                factory.destroySingletons();
            }
            appContext.close();
            LogFactory.release((ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            logger.warn((Object)"Jboss could not be stopped", (Throwable)e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationCtx) throws BeansException {
        logger.debug((Object)"Attempt to set app context");
        applicationContext.set(applicationCtx);
    }

    public ApplicationContext getApplicationContext() {
        logger.debug((Object)"Attempt to get app context");
        return applicationContext.get();
    }
}

