/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.jetty;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.deployer.WebAppDeployer;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.red5.server.LoaderBase;
import org.red5.server.LoaderMBean;
import org.red5.server.jetty.JettyApplicationLoader;
import org.red5.server.jmx.JMXAgent;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class JettyLoader
extends LoaderBase
implements ApplicationContextAware,
LoaderMBean {
    protected static Log log = LogFactory.getLog((String)JettyLoader.class.getName());
    protected String defaultWebConfig = "web-default.xml";
    protected Server jetty;
    protected String jettyConfig = "classpath:/jetty.xml";

    public JettyLoader() {
        JMXAgent.registerMBean(this, this.getClass().getName(), LoaderMBean.class);
    }

    public void init() {
        try {
            if (this.webappFolder == null) {
                this.webappFolder = System.getProperty("red5.root") + "/webapps";
            }
            System.setProperty("red5.webapp.root", this.webappFolder);
            log.info((Object)("Loading jetty6 context from: " + this.jettyConfig));
            ClassPathXmlApplicationContext appCtx = new ClassPathXmlApplicationContext(this.jettyConfig);
            this.jetty = (Server)appCtx.getBean("Server");
            JettyLoader.setApplicationLoader(new JettyApplicationLoader(this.jetty));
            String serverRoot = System.getProperty("red5.root");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Server root: " + serverRoot));
            }
            System.setProperty("jetty.home", serverRoot);
            System.setProperty("jetty.class.path", serverRoot + "/lib");
            log.info((Object)"Starting jetty servlet engine");
            String[] handlersArr = new String[]{"org.mortbay.jetty.webapp.WebInfConfiguration", "org.mortbay.jetty.webapp.WebXmlConfiguration", "org.mortbay.jetty.webapp.JettyWebXmlConfiguration", "org.mortbay.jetty.webapp.TagLibConfiguration", "org.red5.server.jetty.Red5WebPropertiesConfiguration"};
            HandlerCollection handlers = new HandlerCollection();
            handlers.setHandlers(new Handler[]{new ContextHandlerCollection(), new DefaultHandler()});
            this.jetty.setHandler((Handler)handlers);
            try {
                HandlerCollection contexts = (HandlerCollection)this.jetty.getChildHandlerByClass(ContextHandlerCollection.class);
                if (contexts == null) {
                    contexts = (HandlerCollection)this.jetty.getChildHandlerByClass(HandlerCollection.class);
                }
                WebAppDeployer deployer = new WebAppDeployer();
                deployer.setContexts((HandlerContainer)contexts);
                deployer.setWebAppDir(this.webappFolder);
                deployer.setDefaultsDescriptor(this.defaultWebConfig);
                deployer.setConfigurationClasses(handlersArr);
                deployer.setExtract(true);
                deployer.setParentLoaderPriority(true);
                deployer.start();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            this.jetty.start();
        }
        catch (Exception e) {
            log.error((Object)"Error loading jetty", (Throwable)e);
        }
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        applicationContext.set(context);
    }

    public void shutdown() {
        log.info((Object)"Shutting down jetty context");
        JMXAgent.shutdown();
        try {
            this.jetty.stop();
            System.exit(0);
        }
        catch (Exception e) {
            log.warn((Object)"Jetty could not be stopped", (Throwable)e);
            System.exit(1);
        }
    }
}

