/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.jmx;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.red5.server.jmx.JMXFactory;

public class JMXUtil {
    private static Logger log = Logger.getLogger(JMXUtil.class);

    public static void printMBeanInfo(ObjectName objectName, String className) {
        log.info((Object)("Retrieve the management information for the " + className));
        log.info((Object)"MBean using the getMBeanInfo() method of the MBeanServer");
        MBeanServer mbs = JMXFactory.getMBeanServer();
        MBeanInfo info = null;
        try {
            info = mbs.getMBeanInfo(objectName);
        }
        catch (Exception e) {
            log.error((Object)("Could not get MBeanInfo object for " + className + " !!!"), (Throwable)e);
            return;
        }
        log.info((Object)("CLASSNAME: \t" + info.getClassName()));
        log.info((Object)("DESCRIPTION: \t" + info.getDescription()));
        log.info((Object)"ATTRIBUTES");
        MBeanAttributeInfo[] attrInfo = info.getAttributes();
        if (attrInfo.length > 0) {
            for (int i = 0; i < attrInfo.length; ++i) {
                log.info((Object)(" ** NAME: \t" + attrInfo[i].getName()));
                log.info((Object)("    DESCR: \t" + attrInfo[i].getDescription()));
                log.info((Object)("    TYPE: \t" + attrInfo[i].getType() + "\tREAD: " + attrInfo[i].isReadable() + "\tWRITE: " + attrInfo[i].isWritable()));
            }
        } else {
            log.info((Object)" ** No attributes **");
        }
        log.info((Object)"CONSTRUCTORS");
        MBeanConstructorInfo[] constrInfo = info.getConstructors();
        for (int i = 0; i < constrInfo.length; ++i) {
            log.info((Object)(" ** NAME: \t" + constrInfo[i].getName()));
            log.info((Object)("    DESCR: \t" + constrInfo[i].getDescription()));
            log.info((Object)("    PARAM: \t" + constrInfo[i].getSignature().length + " parameter(s)"));
        }
        log.info((Object)"OPERATIONS");
        MBeanOperationInfo[] opInfo = info.getOperations();
        if (opInfo.length > 0) {
            for (int i = 0; i < opInfo.length; ++i) {
                log.info((Object)(" ** NAME: \t" + opInfo[i].getName()));
                log.info((Object)("    DESCR: \t" + opInfo[i].getDescription()));
                log.info((Object)("    PARAM: \t" + opInfo[i].getSignature().length + " parameter(s)"));
            }
        } else {
            log.info((Object)" ** No operations ** ");
        }
        log.info((Object)"NOTIFICATIONS");
        MBeanNotificationInfo[] notifInfo = info.getNotifications();
        if (notifInfo.length > 0) {
            for (int i = 0; i < notifInfo.length; ++i) {
                log.info((Object)(" ** NAME: \t" + notifInfo[i].getName()));
                log.info((Object)("    DESCR: \t" + notifInfo[i].getDescription()));
                String[] notifTypes = notifInfo[i].getNotifTypes();
                for (int j = 0; j < notifTypes.length; ++j) {
                    log.info((Object)("    TYPE: \t" + notifTypes[j]));
                }
            }
        } else {
            log.info((Object)" ** No notifications **");
        }
    }
}

