/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.messaging;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.messaging.AbstractPipe;
import org.red5.server.messaging.IConsumer;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IProvider;
import org.red5.server.messaging.IPushableConsumer;

public class InMemoryPushPushPipe
extends AbstractPipe {
    private static final Log log = LogFactory.getLog(InMemoryPushPushPipe.class);

    public boolean subscribe(IConsumer consumer, Map paramMap) {
        if (!(consumer instanceof IPushableConsumer)) {
            throw new IllegalArgumentException("Non-pushable consumer not supported by PushPushPipe");
        }
        boolean success = super.subscribe(consumer, paramMap);
        if (success) {
            this.fireConsumerConnectionEvent(consumer, 4, paramMap);
        }
        return success;
    }

    public boolean subscribe(IProvider provider, Map paramMap) {
        boolean success = super.subscribe(provider, paramMap);
        if (success) {
            this.fireProviderConnectionEvent(provider, 1, paramMap);
        }
        return success;
    }

    public IMessage pullMessage() {
        return null;
    }

    public IMessage pullMessage(long wait) {
        return null;
    }

    public void pushMessage(IMessage message) throws IOException {
        List<IConsumer> consumerList = Collections.unmodifiableList(this.consumers);
        for (IConsumer consumer : consumerList) {
            try {
                ((IPushableConsumer)consumer).pushMessage(this, message);
            }
            catch (Throwable t) {
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                log.error((Object)"exception when pushing message to consumer", t);
            }
        }
    }
}

