/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.midi;

import java.io.File;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;

public class MidiPlayer {
    public static void main(String[] args) {
        File midiFile;
        String file;
        if (args.length == 0) {
            MidiPlayer.helpAndExit();
        }
        if (!(file = args[0]).endsWith(".mid")) {
            MidiPlayer.helpAndExit();
        }
        if (!(midiFile = new File(file)).exists() || midiFile.isDirectory() || !midiFile.canRead()) {
            MidiPlayer.helpAndExit();
        }
    }

    public MidiPlayer(File midiFile) {
        try {
            Sequencer sequencer = MidiSystem.getSequencer();
            sequencer.setSequence(MidiSystem.getSequence(midiFile));
            sequencer.open();
            sequencer.start();
        }
        catch (MidiUnavailableException mue) {
            System.out.println("Midi device unavailable!");
        }
        catch (InvalidMidiDataException imde) {
            System.out.println("Invalid Midi data!");
        }
        catch (IOException ioe) {
            System.out.println("I/O Error!");
        }
    }

    private static void helpAndExit() {
        System.out.println("Usage: java MidiPlayer midifile.mid");
    }
}

