/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.protocol;

public class ProtocolState {
    public static final String SESSION_KEY = "protocol_state";
    public static byte DECODER_OK = 0;
    public static byte DECODER_CONTINUE = 1;
    public static byte DECODER_BUFFER = (byte)2;
    private int decoderBufferAmount;
    private byte decoderState = DECODER_OK;

    public int getDecoderBufferAmount() {
        return this.decoderBufferAmount;
    }

    public void bufferDecoding(int amount) {
        this.decoderState = DECODER_BUFFER;
        this.decoderBufferAmount = amount;
    }

    public void continueDecoding() {
        this.decoderState = DECODER_CONTINUE;
    }

    public boolean canStartDecoding(int remaining) {
        return remaining >= this.decoderBufferAmount;
    }

    public void startDecoding() {
        this.decoderState = DECODER_OK;
        this.decoderBufferAmount = 0;
    }

    public boolean hasDecodedObject() {
        return this.decoderState == DECODER_OK;
    }

    public boolean canContinueDecoding() {
        return this.decoderState != DECODER_BUFFER;
    }
}

