/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.proxy;

import java.nio.channels.WritableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;
import org.red5.server.net.proxy.ProxyFilter;

public class NetworkDumpFilter
extends IoFilterAdapter {
    protected static Log log = LogFactory.getLog((String)ProxyFilter.class.getName());
    protected WritableByteChannel raw;
    protected WritableByteChannel headers;

    public NetworkDumpFilter(WritableByteChannel headers, WritableByteChannel raw) {
        this.raw = raw;
        this.headers = headers;
    }

    public void messageReceived(IoFilter.NextFilter next, IoSession session, Object message) throws Exception {
        if (message instanceof ByteBuffer) {
            ByteBuffer out = (ByteBuffer)message;
            if (this.headers != null) {
                ByteBuffer header = ByteBuffer.allocate((int)12);
                header.putLong(System.currentTimeMillis());
                header.putInt(out.limit() - out.position());
                header.flip();
                this.headers.write(header.buf());
            }
            if (this.raw != null) {
                this.raw.write(out.asReadOnlyBuffer().buf());
            }
        }
        next.messageReceived(session, message);
    }

    public void sessionClosed(IoFilter.NextFilter next, IoSession session) throws Exception {
        if (this.headers.isOpen()) {
            this.headers.close();
        }
        if (this.raw.isOpen()) {
            this.raw.close();
        }
        next.sessionClosed(session);
    }
}

