/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.remoting;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.compatibility.flex.data.messages.DataMessage;
import org.red5.compatibility.flex.data.messages.SequencedMessage;
import org.red5.compatibility.flex.messaging.messages.AbstractMessage;
import org.red5.compatibility.flex.messaging.messages.AcknowledgeMessage;
import org.red5.compatibility.flex.messaging.messages.AsyncMessage;
import org.red5.compatibility.flex.messaging.messages.CommandMessage;
import org.red5.compatibility.flex.messaging.messages.ErrorMessage;
import org.red5.compatibility.flex.messaging.messages.RemotingMessage;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.api.service.IServiceInvoker;
import org.red5.server.exception.ClientDetailsException;
import org.red5.server.service.ConversionUtils;
import org.red5.server.service.PendingCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexMessagingService {
    public static final String SERVICE_NAME = "flexMessaging";
    protected static Log log = LogFactory.getLog((String)FlexMessagingService.class.getName());
    protected IServiceInvoker serviceInvoker;
    protected Map<String, Object> endpoints = Collections.EMPTY_MAP;

    public void setEndpoints(Map<String, Object> endpoints) {
        this.endpoints = endpoints;
        log.info((Object)("Configured endpoints: " + endpoints));
    }

    public void setServiceInvoker(IServiceInvoker serviceInvoker) {
        this.serviceInvoker = serviceInvoker;
    }

    public static ErrorMessage returnError(AbstractMessage request, String faultCode, String faultString, String faultDetail) {
        ErrorMessage result = new ErrorMessage();
        result.timestamp = System.currentTimeMillis();
        result.headers = request.headers;
        result.destination = request.destination;
        result.correlationId = request.messageId;
        result.faultCode = faultCode;
        result.faultString = faultString;
        result.faultDetail = faultDetail;
        return result;
    }

    public static ErrorMessage returnError(AbstractMessage request, String faultCode, String faultString, Throwable error) {
        ErrorMessage result = FlexMessagingService.returnError(request, faultCode, faultString, "");
        if (error instanceof ClientDetailsException) {
            result.extendedData = ((ClientDetailsException)error).getParameters();
            if (((ClientDetailsException)error).includeStacktrace()) {
                StringBuilder stack = new StringBuilder();
                for (StackTraceElement element : error.getStackTrace()) {
                    stack.append(element.toString()).append("\n");
                }
                result.faultDetail = stack.toString();
            }
        }
        return result;
    }

    public AsyncMessage handleRequest(RemotingMessage msg) {
        if (this.serviceInvoker == null) {
            log.error((Object)("No service invoker configured: " + msg));
            return FlexMessagingService.returnError((AbstractMessage)msg, "Server.Invoke.Error", "No service invoker configured.", "No service invoker configured.");
        }
        Object endpoint = this.endpoints.get(msg.destination);
        if (endpoint == null) {
            log.error((Object)("Endpoint " + msg.destination + " doesn't exist (" + msg + ")"));
            return FlexMessagingService.returnError((AbstractMessage)msg, "Server.Invoke.Error", "Endpoint " + msg.destination + " doesn't exist.", "Endpoint " + msg.destination + " doesn't exist.");
        }
        Object[] args = (Object[])ConversionUtils.convert(msg.body, Object[].class);
        PendingCall call = new PendingCall(msg.operation, args);
        try {
            if (!this.serviceInvoker.invoke((IServiceCall)call, endpoint)) {
                if (call.getException() != null) {
                    Exception err = call.getException();
                    return FlexMessagingService.returnError((AbstractMessage)msg, "Server.Invoke.Error", err.getMessage(), err);
                }
                return FlexMessagingService.returnError((AbstractMessage)msg, "Server.Invoke.Error", "Can't invoke method.", "");
            }
        }
        catch (Throwable err) {
            log.error((Object)"Error while invoking method.", err);
            return FlexMessagingService.returnError((AbstractMessage)msg, "Server.Invoke.Error", err.getMessage(), err);
        }
        AcknowledgeMessage result = new AcknowledgeMessage();
        result.body = call.getResult();
        result.headers = msg.headers;
        result.clientId = msg.clientId;
        result.correlationId = msg.messageId;
        return result;
    }

    public AsyncMessage handleRequest(CommandMessage msg) {
        AsyncMessage result = null;
        switch (msg.operation) {
            case 5: {
                result = new AcknowledgeMessage();
                result.clientId = msg.clientId;
                result.correlationId = msg.messageId;
                break;
            }
            case 0: {
                result = new AcknowledgeMessage();
                result.clientId = msg.clientId;
                result.correlationId = msg.messageId;
                break;
            }
            case 2: {
                result = new AcknowledgeMessage();
                result.clientId = msg.clientId;
                result.correlationId = msg.messageId;
                result.destination = msg.destination;
                break;
            }
            default: {
                log.error((Object)("Unknown CommandMessage request: " + msg));
                result = FlexMessagingService.returnError((AbstractMessage)msg, "notImplemented", "Don't know how to handle " + msg, "Don't know how to handle " + msg);
            }
        }
        return result;
    }

    private void evaluateDataUpdate(DataMessage msg, DataMessage event) {
        switch (event.operation) {
            case 3: {
                List contents = (List)event.body;
                List attributeNames = (List)contents.get(0);
                Map oldValues = (Map)contents.get(1);
                Map newValues = (Map)contents.get(2);
                break;
            }
            default: {
                log.error((Object)("Unknown data update request: " + event));
            }
        }
    }

    public AsyncMessage handleRequest(DataMessage msg) {
        SequencedMessage result = new SequencedMessage();
        result.clientId = msg.clientId;
        result.destination = msg.destination;
        result.correlationId = msg.messageId;
        switch (msg.operation) {
            case 10: {
                result.body = new Object[]{msg.body};
                result.sequenceId = 0L;
                result.sequenceSize = 1L;
                break;
            }
            case 7: {
                for (DataMessage event : (List)msg.body) {
                    this.evaluateDataUpdate(msg, event);
                }
                AcknowledgeMessage res = new AcknowledgeMessage();
                res.clientId = msg.clientId;
                res.destination = msg.destination;
                res.correlationId = msg.messageId;
                res.body = msg.body;
                return res;
            }
            default: {
                log.error((Object)("Unknown DataMessage request: " + msg));
                return FlexMessagingService.returnError((AbstractMessage)msg, "notImplemented", "Don't know how to handle " + msg, "Don't know how to handle " + msg);
            }
        }
        return result;
    }

    public ErrorMessage handleRequest(AbstractMessage msg) {
        log.error((Object)("Unknown flex compatibility request: " + msg));
        return FlexMessagingService.returnError(msg, "notImplemented", "Don't know how to handle " + msg, "Don't know how to handle " + msg);
    }
}

