/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.api.IConnection;
import org.red5.server.api.IContext;
import org.red5.server.api.IGlobalScope;
import org.red5.server.api.IScope;
import org.red5.server.api.IScopeHandler;
import org.red5.server.api.IServer;
import org.red5.server.api.ScopeUtils;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.api.so.ISharedObject;
import org.red5.server.api.so.ISharedObjectSecurity;
import org.red5.server.api.so.ISharedObjectSecurityService;
import org.red5.server.api.so.ISharedObjectService;
import org.red5.server.api.stream.IClientBroadcastStream;
import org.red5.server.api.stream.IClientStream;
import org.red5.server.api.stream.IStreamService;
import org.red5.server.exception.ClientRejectedException;
import org.red5.server.exception.ScopeNotFoundException;
import org.red5.server.exception.ScopeShuttingDownException;
import org.red5.server.messaging.IConsumer;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.net.rtmp.BaseRTMPHandler;
import org.red5.server.net.rtmp.Channel;
import org.red5.server.net.rtmp.DeferredResult;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.event.ChunkSize;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.Ping;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.net.rtmp.status.Status;
import org.red5.server.net.rtmp.status.StatusObject;
import org.red5.server.net.rtmp.status.StatusObjectService;
import org.red5.server.so.ISharedObjectEvent;
import org.red5.server.so.SharedObjectEvent;
import org.red5.server.so.SharedObjectMessage;
import org.red5.server.so.SharedObjectService;
import org.red5.server.stream.IBroadcastScope;
import org.red5.server.stream.StreamService;

public class RTMPHandler
extends BaseRTMPHandler {
    protected static Log log = LogFactory.getLog((String)RTMPHandler.class.getName());
    protected StatusObjectService statusObjectService;
    protected IServer server;

    public void setServer(IServer server) {
        this.server = server;
    }

    public void setStatusObjectService(StatusObjectService statusObjectService) {
        this.statusObjectService = statusObjectService;
    }

    protected void onChunkSize(RTMPConnection conn, Channel channel, Header source, ChunkSize chunkSize) {
        for (IClientStream stream : conn.getStreams()) {
            IClientBroadcastStream bs;
            IBroadcastScope scope;
            if (!(stream instanceof IClientBroadcastStream) || (scope = (IBroadcastScope)(bs = (IClientBroadcastStream)stream).getScope().getBasicScope("bs", bs.getPublishedName())) == null) continue;
            OOBControlMessage setChunkSize = new OOBControlMessage();
            setChunkSize.setTarget("ClientBroadcastStream");
            setChunkSize.setServiceName("chunkSize");
            if (setChunkSize.getServiceParamMap() == null) {
                setChunkSize.setServiceParamMap(new HashMap());
            }
            setChunkSize.getServiceParamMap().put("chunkSize", chunkSize.getSize());
            scope.sendOOBControlMessage((IConsumer)null, setChunkSize);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Sending chunksize " + chunkSize + " to " + bs.getProvider()));
        }
    }

    protected void invokeCall(RTMPConnection conn, IServiceCall call) {
        IScope scope = conn.getScope();
        if (scope.hasHandler()) {
            IScopeHandler handler = scope.getHandler();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scope: " + scope));
                log.debug((Object)("Handler: " + handler));
            }
            if (!handler.serviceCall(conn, call)) {
                return;
            }
        }
        IContext context = scope.getContext();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Context: " + context));
        }
        context.getServiceInvoker().invoke(call, scope);
    }

    private boolean invokeCall(RTMPConnection conn, IServiceCall call, Object service) {
        IScope scope = conn.getScope();
        IContext context = scope.getContext();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Scope: " + scope));
            log.debug((Object)("Service: " + service));
            log.debug((Object)("Context: " + context));
        }
        return context.getServiceInvoker().invoke(call, service);
    }

    protected void onInvoke(RTMPConnection conn, Channel channel, Header source, Notify invoke, RTMP rtmp) {
        IServiceCall call;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invoke: " + invoke));
        }
        if ((call = invoke.getCall()).getServiceMethodName().equals("_result") || call.getServiceMethodName().equals("_error")) {
            this.handlePendingCallResult(conn, invoke);
            return;
        }
        boolean disconnectOnReturn = false;
        if (call.getServiceName() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("call: " + call));
            }
            String action = call.getServiceMethodName();
            if (!conn.isConnected()) {
                if (action.equals("connect")) {
                    Map params;
                    block52: {
                        String path;
                        log.debug((Object)"connect");
                        params = invoke.getConnectionParams();
                        String host = this.getHostname((String)params.get("tcUrl"));
                        if (host.endsWith(":1935")) {
                            host = host.substring(0, host.length() - 5);
                        }
                        if ((path = (String)params.get("app")).indexOf("?") != -1) {
                            int idx = path.indexOf("?");
                            params.put("queryString", path.substring(idx));
                            path = path.substring(0, idx);
                        }
                        params.put("path", path);
                        String sessionId = null;
                        conn.setup(host, path, sessionId, params);
                        try {
                            StatusObject status;
                            IGlobalScope global = this.server.lookupGlobal(host, path);
                            if (global == null) {
                                call.setStatus((byte)16);
                                if (call instanceof IPendingServiceCall) {
                                    StatusObject status2 = this.getStatus("NetConnection.Connect.InvalidApp");
                                    status2.setDescription("No scope \"" + path + "\" on this server.");
                                    ((IPendingServiceCall)call).setResult(status2);
                                }
                                log.info((Object)("No application scope found for " + path + " on host " + host + ". Mispelled or missing application folder?"));
                                disconnectOnReturn = true;
                                break block52;
                            }
                            IContext context = global.getContext();
                            IScope scope = null;
                            try {
                                scope = context.resolveScope(path);
                            }
                            catch (ScopeNotFoundException err) {
                                call.setStatus((byte)16);
                                if (call instanceof IPendingServiceCall) {
                                    status = this.getStatus("NetConnection.Connect.Rejected");
                                    status.setDescription("No scope \"" + path + "\" on this server.");
                                    ((IPendingServiceCall)call).setResult(status);
                                }
                                if (log.isInfoEnabled()) {
                                    log.info((Object)("Scope " + path + " not found on " + host));
                                }
                                disconnectOnReturn = true;
                            }
                            catch (ScopeShuttingDownException err) {
                                call.setStatus((byte)21);
                                if (call instanceof IPendingServiceCall) {
                                    status = this.getStatus("NetConnection.Connect.AppShutdown");
                                    status.setDescription("Application at \"" + path + "\" is currently shutting down.");
                                    ((IPendingServiceCall)call).setResult(status);
                                }
                                if (log.isInfoEnabled()) {
                                    log.info((Object)("Application at " + path + " currently shutting down on " + host));
                                }
                                disconnectOnReturn = true;
                            }
                            if (scope == null) break block52;
                            if (log.isDebugEnabled()) {
                                log.info((Object)("Connecting to: " + scope));
                            }
                            try {
                                IPendingServiceCall pc;
                                boolean okayToConnect = call.getArguments() != null ? conn.connect(scope, call.getArguments()) : conn.connect(scope);
                                if (okayToConnect) {
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)"connected");
                                        log.debug((Object)("client: " + conn.getClient()));
                                    }
                                    call.setStatus((byte)2);
                                    if (call instanceof IPendingServiceCall) {
                                        pc = (IPendingServiceCall)call;
                                        pc.setResult(this.getStatus("NetConnection.Connect.Success"));
                                    }
                                    conn.getChannel(2).write(new Ping(0, 0, -1));
                                    conn.startRoundTripMeasurement();
                                    break block52;
                                }
                                log.debug((Object)"connect failed");
                                call.setStatus((byte)18);
                                if (call instanceof IPendingServiceCall) {
                                    pc = (IPendingServiceCall)call;
                                    pc.setResult(this.getStatus("NetConnection.Connect.Rejected"));
                                }
                                disconnectOnReturn = true;
                            }
                            catch (ClientRejectedException rejected) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"connect rejected");
                                }
                                call.setStatus((byte)18);
                                if (call instanceof IPendingServiceCall) {
                                    IPendingServiceCall pc = (IPendingServiceCall)call;
                                    StatusObject status3 = this.getStatus("NetConnection.Connect.Rejected");
                                    if (rejected.getReason() != null) {
                                        status3.setApplication(rejected.getReason());
                                    }
                                    pc.setResult(status3);
                                }
                                disconnectOnReturn = true;
                            }
                        }
                        catch (RuntimeException e) {
                            call.setStatus((byte)20);
                            if (call instanceof IPendingServiceCall) {
                                IPendingServiceCall pc = (IPendingServiceCall)call;
                                pc.setResult(this.getStatus("NetConnection.Connect.Failed"));
                            }
                            log.error((Object)"Error connecting", (Throwable)e);
                            disconnectOnReturn = true;
                        }
                    }
                    if (params.get("objectEncoding") == Integer.valueOf(3) && call instanceof IPendingServiceCall) {
                        HashMap<String, Integer> result;
                        Object pcResult = ((IPendingServiceCall)call).getResult();
                        if (pcResult instanceof Map) {
                            result = (HashMap<String, Integer>)pcResult;
                            result.put("objectEncoding", 3);
                        } else if (pcResult instanceof StatusObject) {
                            result = new HashMap<String, Integer>();
                            StatusObject status = (StatusObject)pcResult;
                            result.put("code", (Integer)((Object)status.getCode()));
                            result.put("description", (Integer)((Object)status.getDescription()));
                            result.put("application", (Integer)status.getApplication());
                            result.put("level", (Integer)((Object)status.getLevel()));
                            result.put("objectEncoding", 3);
                            ((IPendingServiceCall)call).setResult(result);
                        }
                        rtmp.setEncoding(IConnection.Encoding.AMF3);
                    }
                }
            } else if (action.equals("disconnect")) {
                conn.close();
            } else if (action.equals("createStream") || action.equals("deleteStream") || action.equals("releaseStream") || action.equals("publish") || action.equals("play") || action.equals("seek") || action.equals("pause") || action.equals("closeStream") || action.equals("receiveVideo") || action.equals("receiveAudio")) {
                IStreamService streamService = (IStreamService)ScopeUtils.getScopeService(conn.getScope(), IStreamService.class, StreamService.class);
                Status status = null;
                try {
                    if (!this.invokeCall(conn, call, streamService)) {
                        status = this.getStatus("NetStream.InvalidArg").asStatus();
                        status.setDescription("Failed to " + action + " (stream ID: " + source.getStreamId() + ")");
                    }
                }
                catch (Throwable err) {
                    log.error((Object)("Error while invoking " + action + " on stream service."), err);
                    status = this.getStatus("NetStream.Failed").asStatus();
                    status.setDescription("Error while invoking " + action + " (stream ID: " + source.getStreamId() + ")");
                    status.setDetails(err.getMessage());
                }
                if (status != null) {
                    channel.sendStatus(status);
                }
            } else {
                this.invokeCall(conn, call);
            }
        } else if (conn.isConnected()) {
            this.invokeCall(conn, call);
        } else {
            log.warn((Object)"Not connected, closing connection");
            conn.close();
        }
        if (invoke instanceof Invoke) {
            IPendingServiceCall psc;
            Object result;
            if (source.getStreamId() != 0 && (call.getStatus() == 4 || call.getStatus() == 3)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Method does not have return value, do not reply");
                }
                return;
            }
            boolean sendResult = true;
            if (call instanceof IPendingServiceCall && (result = (psc = (IPendingServiceCall)call).getResult()) instanceof DeferredResult) {
                DeferredResult dr = (DeferredResult)result;
                dr.setServiceCall(psc);
                dr.setChannel(channel);
                dr.setInvokeId(invoke.getInvokeId());
                conn.registerDeferredResult(dr);
                sendResult = false;
            }
            if (sendResult) {
                Invoke reply = new Invoke();
                reply.setCall(call);
                reply.setInvokeId(invoke.getInvokeId());
                channel.write(reply);
                if (disconnectOnReturn) {
                    conn.close();
                }
            }
        }
    }

    public StatusObject getStatus(String code) {
        return this.statusObjectService.getStatusObject(code);
    }

    protected void onPing(RTMPConnection conn, Channel channel, Header source, Ping ping) {
        switch (ping.getValue1()) {
            case 3: {
                if (ping.getValue2() != 0) {
                    IClientStream stream = conn.getStreamById(ping.getValue2());
                    int buffer = ping.getValue3();
                    if (stream != null) {
                        stream.setClientBufferDuration(buffer);
                        if (!log.isInfoEnabled()) break;
                        log.info((Object)("Setting client buffer on stream: " + buffer));
                        break;
                    }
                    conn.rememberStreamBufferDuration(ping.getValue2(), buffer);
                    if (!log.isInfoEnabled()) break;
                    log.info((Object)("Remembering client buffer on stream: " + buffer));
                    break;
                }
                log.warn((Object)("Unhandled ping: " + ping));
                break;
            }
            case 7: {
                conn.pingReceived(ping);
                break;
            }
            default: {
                log.warn((Object)("Unhandled ping: " + ping));
            }
        }
    }

    private void sendSOCreationFailed(RTMPConnection conn, String name, boolean persistent) {
        SharedObjectMessage msg = new SharedObjectMessage(name, 0, persistent);
        msg.addEvent(new SharedObjectEvent(ISharedObjectEvent.Type.CLIENT_STATUS, "error", "SharedObject.ObjectCreationFailed"));
        conn.getChannel(3).write(msg);
    }

    protected void onSharedObject(RTMPConnection conn, Channel channel, Header source, SharedObjectMessage object) {
        ISharedObject so;
        String name = object.getName();
        boolean persistent = object.isPersistent();
        IScope scope = conn.getScope();
        if (scope == null) {
            this.sendSOCreationFailed(conn, name, persistent);
            return;
        }
        ISharedObjectService sharedObjectService = (ISharedObjectService)ScopeUtils.getScopeService(scope, ISharedObjectService.class, SharedObjectService.class, false);
        if (!sharedObjectService.hasSharedObject(scope, name)) {
            ISharedObjectSecurityService security = (ISharedObjectSecurityService)ScopeUtils.getScopeService(scope, ISharedObjectSecurityService.class);
            if (security != null) {
                for (ISharedObjectSecurity handler : security.getSharedObjectSecurity()) {
                    if (handler.isCreationAllowed(scope, name, persistent)) continue;
                    this.sendSOCreationFailed(conn, name, persistent);
                    return;
                }
            }
            if (!sharedObjectService.createSharedObject(scope, name, persistent)) {
                this.sendSOCreationFailed(conn, name, persistent);
                return;
            }
        }
        if ((so = sharedObjectService.getSharedObject(scope, name)).isPersistentObject() != persistent) {
            SharedObjectMessage msg = new SharedObjectMessage(name, 0, persistent);
            msg.addEvent(new SharedObjectEvent(ISharedObjectEvent.Type.CLIENT_STATUS, "error", "SharedObject.BadPersistence"));
            conn.getChannel(3).write(msg);
        }
        so.dispatchEvent(object);
    }
}

