/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.red5.server.net.protocol.ProtocolState;
import org.red5.server.net.rtmp.IRTMPHandler;
import org.red5.server.net.rtmp.RTMPMinaConnection;
import org.red5.server.net.rtmp.codec.RTMP;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RTMPMinaIoHandler
extends IoHandlerAdapter
implements ApplicationContextAware {
    protected static Log log = LogFactory.getLog((String)RTMPMinaIoHandler.class.getName());
    protected IRTMPHandler handler;
    protected boolean mode = false;
    protected ApplicationContext appCtx;
    private ProtocolCodecFactory codecFactory = null;

    public void setHandler(IRTMPHandler handler) {
        this.handler = handler;
    }

    public void setMode(boolean mode) {
        this.mode = mode;
    }

    public void setCodecFactory(ProtocolCodecFactory codecFactory) {
        this.codecFactory = codecFactory;
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exception caught", cause);
        }
    }

    public void messageReceived(IoSession session, Object in) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"messageRecieved");
        }
        RTMPMinaConnection conn = (RTMPMinaConnection)session.getAttachment();
        ProtocolState state = (ProtocolState)session.getAttribute("protocol_state");
        if (in instanceof ByteBuffer) {
            this.rawBufferRecieved(state, (ByteBuffer)in, session);
            return;
        }
        this.handler.messageReceived(conn, state, in);
    }

    protected void rawBufferRecieved(ProtocolState state, ByteBuffer in, IoSession session) {
        RTMP rtmp = (RTMP)state;
        if (!rtmp.getMode()) {
            if (rtmp.getState() != 1) {
                log.warn((Object)"Raw buffer after handshake, something odd going on");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Handshake 2nd phase");
                log.debug((Object)("handshake size:" + in.remaining()));
            }
            ByteBuffer out = ByteBuffer.allocate((int)3073);
            out.put((byte)3);
            out.putInt(1);
            out.fill((byte)0, 1532);
            out.put(in);
            out.flip();
            rtmp.setHandshake(out, 9, 1528);
            session.write((Object)out);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Handshake 3d phase");
                log.debug((Object)("handshake size:" + in.remaining()));
            }
            in.skip(1);
            ByteBuffer out = ByteBuffer.allocate((int)1536);
            int limit = in.limit();
            in.limit(in.position() + 1536);
            out.put(in);
            out.flip();
            in.limit(limit);
            in.skip(1536);
            session.write((Object)out);
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"messageSent");
        }
        session.getAttribute("protocol_state");
        RTMPMinaConnection conn = (RTMPMinaConnection)session.getAttachment();
        this.handler.messageSent(conn, message);
        if (this.mode && message instanceof ByteBuffer && ((ByteBuffer)message).limit() == 1536) {
            this.handler.connectionOpened((RTMPMinaConnection)session.getAttachment(), (RTMP)session.getAttribute("protocol_state"));
        }
    }

    public void sessionOpened(IoSession session) throws Exception {
        super.sessionOpened(session);
        RTMP rtmp = (RTMP)session.getAttribute("protocol_state");
        if (rtmp.getMode()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Handshake 1st phase");
            }
            ByteBuffer out = ByteBuffer.allocate((int)1537);
            out.put((byte)3);
            out.fill((byte)0, 1536);
            out.flip();
            session.write((Object)out);
        } else {
            RTMPMinaConnection conn = (RTMPMinaConnection)session.getAttachment();
            this.handler.connectionOpened(conn, rtmp);
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        RTMP rtmp = (RTMP)session.getAttribute("protocol_state");
        ByteBuffer buf = (ByteBuffer)session.getAttribute("buffer");
        if (buf != null) {
            buf.release();
        }
        RTMPMinaConnection conn = (RTMPMinaConnection)session.getAttachment();
        this.handler.connectionClosed(conn, rtmp);
        session.removeAttribute("protocol_state");
        session.setAttachment(null);
    }

    public void sessionCreated(IoSession session) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Session created");
        }
        session.setAttribute("protocol_state", (Object)new RTMP(this.mode));
        session.getFilterChain().addFirst("protocolFilter", (IoFilter)new ProtocolCodecFilter(this.codecFactory));
        if (log.isDebugEnabled()) {
            session.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        RTMPMinaConnection conn = this.appCtx != null ? (RTMPMinaConnection)this.appCtx.getBean("rtmpMinaConnection") : new RTMPMinaConnection();
        conn.setIoSession(session);
        session.setAttachment((Object)conn);
    }

    public void setApplicationContext(ApplicationContext appCtx) throws BeansException {
        this.appCtx = appCtx;
    }
}

