/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.event;

import org.red5.server.api.event.IEvent;
import org.red5.server.api.event.IEventListener;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.message.Constants;
import org.red5.server.net.rtmp.message.Header;

public abstract class BaseEvent
implements Constants,
IRTMPEvent {
    private static final boolean allocationDebugging = false;
    private IEvent.Type type;
    protected Object object;
    protected IEventListener source;
    protected int timestamp;
    protected Header header = null;
    protected int refcount = 1;

    public BaseEvent(IEvent.Type type) {
        this(type, null);
    }

    public BaseEvent(IEvent.Type type, IEventListener source) {
        this.type = type;
        this.source = source;
    }

    public IEvent.Type getType() {
        return this.type;
    }

    public Object getObject() {
        return this.object;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public IEventListener getSource() {
        return this.source;
    }

    public void setSource(IEventListener source) {
        this.source = source;
    }

    public abstract byte getDataType();

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public synchronized void retain() {
        if (this.refcount > 0) {
            ++this.refcount;
        }
    }

    public synchronized void release() {
        if (this.refcount > 0) {
            --this.refcount;
            if (this.refcount == 0) {
                this.releaseInternal();
            }
        }
    }

    protected abstract void releaseInternal();
}

