/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.status;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.red5.annotations.Anonymous;
import org.red5.io.object.ICustomSerializable;
import org.red5.io.object.Output;
import org.red5.io.object.Serializer;
import org.red5.server.net.rtmp.status.Status;

@Anonymous
public class StatusObject
implements Serializable,
ICustomSerializable {
    private static final long serialVersionUID = 8817297676191096283L;
    public static final String ERROR = "error";
    public static final String STATUS = "status";
    public static final String WARNING = "warning";
    protected String code;
    protected String level;
    protected String description = "";
    protected Object application;
    protected Map<String, Object> additional;

    public StatusObject() {
    }

    public StatusObject(String code, String level, String description) {
        this.code = code;
        this.level = level;
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setApplication(Object application) {
        this.application = application;
    }

    public Object getApplication() {
        return this.application;
    }

    public String toString() {
        return "Status code: " + this.getCode() + " desc: " + this.getDescription() + " level: " + this.getLevel();
    }

    public Status asStatus() {
        return new Status(this.getCode(), this.getLevel(), this.getDescription());
    }

    public void setAdditional(String name, Object value) {
        if ("code".equals(name) || "level".equals(name) || "description".equals(name) || "application".equals(name)) {
            throw new RuntimeException("the name \"" + name + "\" is reserved");
        }
        if (this.additional == null) {
            this.additional = new HashMap<String, Object>();
        }
        this.additional.put(name, value);
    }

    public void serialize(Output output, Serializer serializer) {
        output.putString("level");
        output.writeString(this.getLevel());
        output.putString("code");
        output.writeString(this.getCode());
        output.putString("description");
        output.writeString(this.getDescription());
        if (this.getApplication() != null) {
            output.putString("application");
            serializer.serialize(output, this.getApplication());
        }
        if (this.additional != null) {
            for (Map.Entry<String, Object> entry : this.additional.entrySet()) {
                output.putString(entry.getKey());
                serializer.serialize(output, entry.getValue());
            }
        }
    }
}

