/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmpt;

import java.util.Map;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Server;
import org.apache.catalina.Wrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.api.IServer;
import org.red5.server.tomcat.TomcatLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatRTMPTLoader
extends TomcatLoader {
    protected static Log log = LogFactory.getLog((String)TomcatRTMPTLoader.class.getName());
    protected Server rtmptServer;
    protected IServer server;
    private Host host;
    private Context context;

    public void setServer(IServer server) {
        log.debug((Object)"RTMPT setServer");
        this.server = server;
    }

    @Override
    public void init() {
        log.info((Object)"Loading RTMPT context");
        try {
            TomcatRTMPTLoader.getApplicationContext();
        }
        catch (Exception e) {
            log.error((Object)"Error loading tomcat configuration", (Throwable)e);
        }
        this.host.addChild((Container)this.context);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Null check - engine: " + (null == this.engine) + " host: " + (null == this.host)));
        }
        this.engine.addChild((Container)this.host);
        this.embedded.addEngine(this.engine);
        this.embedded.addConnector(this.connector);
        try {
            log.info((Object)"Starting RTMPT engine");
            this.embedded.start();
        }
        catch (LifecycleException e) {
            log.error((Object)"Error loading tomcat", (Throwable)e);
        }
    }

    public void setHost(Host host) {
        log.debug((Object)"RTMPT setHost");
        this.host = host;
    }

    public void setContext(Map<String, String> contextMap) {
        log.debug((Object)"RTMPT setContext (map)");
        this.context = this.embedded.createContext(contextMap.get("path"), contextMap.get("docBase"));
        this.context.setReloadable(false);
    }

    public void setWrapper(Wrapper wrapper) {
        log.debug((Object)"RTMPT setWrapper");
        this.context.addChild((Container)wrapper);
    }

    public void setMappings(Map<String, String> mappings) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Servlet mappings: " + mappings.size()));
        }
        for (String key : mappings.keySet()) {
            this.context.addServletMapping(mappings.get(key), key);
        }
    }
}

