/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.object.Deserializer;
import org.red5.io.utils.HexDump;
import org.red5.server.net.protocol.ProtocolException;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.codec.RTMPProtocolDecoder;
import org.red5.server.net.rtmp.message.Packet;

public class CaptureViewerServlet
extends HttpServlet {
    private static final long serialVersionUID = -1306102075849918166L;
    private static Log log = LogFactory.getLog((String)CaptureViewerServlet.class.getName());
    private RTMPProtocolDecoder decoder;
    private Deserializer deserializer;

    public void init() throws ServletException {
        super.init();
        try {
            this.decoder = new RTMPProtocolDecoder();
            this.deserializer = new Deserializer();
            this.decoder.setDeserializer(this.deserializer);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        try {
            PrintWriter out;
            block14: {
                MappedByteBuffer rawMappedFile;
                MappedByteBuffer capMappedFile;
                out = resp.getWriter();
                resp.setHeader("Content-type", "text/html");
                out.write("<html><head>");
                out.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"capture.css\" />");
                out.write("</head><body>");
                String capFileName = req.getRequestURI().substring(req.getContextPath().length() + 1);
                String rawFileName = capFileName.substring(0, capFileName.length() - 4) + ".raw";
                File capFile = new File(this.getServletContext().getRealPath(capFileName));
                File rawFile = new File(this.getServletContext().getRealPath(rawFileName));
                FileInputStream capFis = new FileInputStream(capFile);
                FileInputStream rawFis = new FileInputStream(rawFile);
                FileChannel capChannel = capFis.getChannel();
                FileChannel rawChannel = rawFis.getChannel();
                try {
                    capMappedFile = capChannel.map(FileChannel.MapMode.READ_ONLY, 0L, capChannel.size());
                    rawMappedFile = rawChannel.map(FileChannel.MapMode.READ_ONLY, 0L, rawChannel.size());
                }
                catch (IOException e) {
                    log.error((Object)"error mapping file", (Throwable)e);
                    return;
                }
                capMappedFile.order(ByteOrder.BIG_ENDIAN);
                rawMappedFile.order(ByteOrder.BIG_ENDIAN);
                ByteBuffer cap = ByteBuffer.wrap((java.nio.ByteBuffer)capMappedFile);
                ByteBuffer in = ByteBuffer.wrap((java.nio.ByteBuffer)rawMappedFile);
                boolean serverMode = cap.get() == 1;
                out.write("Mode: " + (serverMode ? "UPSTREAM" : "DOWNSTREAM"));
                RTMP state = new RTMP(serverMode);
                int id = 0;
                try {
                    int nextTimePos = 0;
                    long time = 0L;
                    long offset = -1L;
                    long read = 0L;
                    try {
                        while (true) {
                            block17: {
                                block15: {
                                    Object decodedObject;
                                    block16: {
                                        if (in.position() >= nextTimePos) {
                                            if (cap.remaining() < 12) continue;
                                            time = cap.getLong();
                                            if (offset == -1L) {
                                                offset = time;
                                            }
                                            read = cap.getInt();
                                            nextTimePos = (int)((long)nextTimePos + read);
                                            out.write("<div class=\"time\">TIME: " + (time -= offset) + " READ: " + read + "</div>");
                                            continue;
                                        }
                                        int remaining = in.remaining();
                                        if (!state.canStartDecoding(remaining)) break block14;
                                        state.startDecoding();
                                        decodedObject = this.decoder.decode(state, in);
                                        if (!state.hasDecodedObject()) break block15;
                                        if (!(decodedObject instanceof Packet)) break block16;
                                        out.write(this.formatHTML((Packet)decodedObject, id++, 0L));
                                        break block17;
                                    }
                                    if (!(decodedObject instanceof ByteBuffer)) break block17;
                                    ByteBuffer buf = (ByteBuffer)decodedObject;
                                    out.write("<div class=\"handshake\"><pre>" + HexDump.formatHexDump(buf.getHexDump()) + "</pre></div>");
                                    break block17;
                                }
                                if (state.canContinueDecoding()) {
                                    continue;
                                }
                                break;
                            }
                            if (!in.hasRemaining()) break;
                        }
                    }
                    catch (ProtocolException pvx) {
                        log.error((Object)"Error decoding buffer", (Throwable)pvx);
                    }
                    catch (Exception ex) {
                        log.error((Object)"Error decoding buffer", (Throwable)ex);
                    }
                }
                catch (RuntimeException e) {
                    log.error((Object)"Error", (Throwable)e);
                }
            }
            out.flush();
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public String formatHTML(Packet packet, int id, long time) {
        StringBuilder out = new StringBuilder();
        out.append("<div id=\"packet_");
        out.append(id);
        out.append("\" class=");
        out.append("channel_");
        out.append(packet.getHeader().getChannelId());
        out.append(" datatype_");
        out.append(packet.getHeader().getDataType());
        out.append("\">\n<pre>\n");
        out.append(packet.getHeader().toString());
        out.append("\n");
        out.append(packet.getMessage().toString());
        out.append("\n<pre>\n</div>\n\n");
        return out.toString();
    }
}

