/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.udp;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.red5.io.utils.HexDump;

public class BasicHandler
extends IoHandlerAdapter {
    protected static Log log = LogFactory.getLog((String)BasicHandler.class.getName());
    static final int TICK = 1000;
    static final int TIMEOUT = 10000;
    static final byte NOOP = 0;
    static final byte JOIN = 1;
    static final byte LIST = 2;
    static final byte SEND = 3;
    static final byte EXIT = 4;
    final ByteBuffer NOOP_MSG = ByteBuffer.wrap((byte[])new byte[]{0}).asReadOnlyBuffer();
    protected Timer timer = new Timer("Timer", true);
    protected Set<IoSession> sessions = Collections.synchronizedSet(new HashSet());
    protected boolean showInfo = false;

    public BasicHandler() {
        this.timer.scheduleAtFixedRate((TimerTask)new TimeoutTask(), 0L, 1000L);
        this.showInfo = log.isInfoEnabled();
    }

    public void exceptionCaught(IoSession session, Throwable ex) throws Exception {
        if (this.showInfo) {
            log.info((Object)("Exception: " + session.getRemoteAddress().toString()), ex);
        }
        this.sessions.remove(session);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        if (this.showInfo) {
            log.info((Object)("Incomming: " + session.getRemoteAddress().toString()));
        }
        ByteBuffer data = (ByteBuffer)message;
        log.info((Object)HexDump.prettyPrintHex(data.asReadOnlyBuffer().array()));
        byte type = data.get();
        data.position(0);
        switch (type) {
            case 0: {
                break;
            }
            case 1: {
                if (this.sessions.contains(session)) break;
                this.sessions.add(session);
                this.join(session);
                break;
            }
            case 2: {
                this.list(session);
                break;
            }
            case 3: {
                this.broadcast(session, data);
                break;
            }
            case 4: {
                if (!this.sessions.contains(session)) break;
                this.sessions.remove(session);
                session.close();
                this.leave(session);
                break;
            }
            default: {
                if (this.showInfo) {
                    log.info((Object)("Unknown (play echo): " + session.getRemoteAddress().toString()));
                }
                this.echo(session, data);
            }
        }
    }

    protected void echo(IoSession session, ByteBuffer data) {
        session.write((Object)data);
    }

    protected void broadcast(IoSession exclude, ByteBuffer data) {
        for (IoSession session : this.sessions) {
            if (exclude != null && exclude.equals(session)) continue;
            if (this.showInfo) {
                log.info((Object)("Sending: " + session.getRemoteAddress().toString()));
            }
            data.acquire();
            session.write((Object)data);
        }
    }

    protected void list(IoSession to) {
        int size = 5 + this.sessions.size() * 4;
        ByteBuffer msg = ByteBuffer.allocate((int)size);
        msg.put((byte)2);
        msg.putInt(this.sessions.size());
        for (IoSession session : this.sessions) {
            msg.putInt(session.getRemoteAddress().hashCode());
        }
        msg.flip();
        to.write((Object)msg);
    }

    protected void leave(IoSession session) {
        int size = 5;
        ByteBuffer msg = ByteBuffer.allocate((int)5);
        msg.put((byte)4);
        msg.putInt(session.getRemoteAddress().hashCode());
        msg.flip();
        this.broadcast(null, msg);
    }

    protected void join(IoSession session) {
        int size = 5;
        ByteBuffer msg = ByteBuffer.allocate((int)5);
        msg.put((byte)1);
        msg.putInt(session.getRemoteAddress().hashCode());
        msg.flip();
        this.broadcast(null, msg);
    }

    public void sessionCreated(IoSession session) throws Exception {
        if (this.showInfo) {
            log.info((Object)("Created: " + session.getRemoteAddress().toString()));
        }
    }

    protected class TimeoutTask
    extends TimerTask {
        protected TimeoutTask() {
        }

        public void run() {
            long kill = System.currentTimeMillis() - 10000L;
            LinkedList<IoSession> remove = new LinkedList<IoSession>();
            for (IoSession session : BasicHandler.this.sessions) {
                if (session.getLastReadTime() < kill) {
                    if (BasicHandler.this.showInfo) {
                        log.info((Object)("Timout: " + session.getRemoteAddress().toString()));
                    }
                    remove.add(session);
                    continue;
                }
                session.write((Object)BasicHandler.this.NOOP_MSG.asReadOnlyBuffer());
            }
            if (remove.size() == 0) {
                return;
            }
            for (IoSession session : remove) {
                BasicHandler.this.sessions.remove(session);
                session.close();
            }
            for (IoSession session : remove) {
                BasicHandler.this.leave(session);
            }
        }
    }
}

