/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.persistence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.amf.Output;
import org.red5.server.api.IScope;
import org.red5.server.api.persistence.IPersistable;
import org.red5.server.net.servlet.ServletUtils;
import org.red5.server.persistence.FilePersistenceThread;
import org.red5.server.persistence.RamPersistence;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;

public class FilePersistence
extends RamPersistence {
    private Log log = LogFactory.getLog((String)FilePersistence.class.getName());
    private String path = "persistence";
    private String rootDir = "";
    private String extension = ".red5";
    private boolean checkForEmptyDirectories = true;
    private FilePersistenceThread storeThread = null;

    public FilePersistence(ResourcePatternResolver resolver) {
        super(resolver);
        this.setPath(this.path);
        this.storeThread = FilePersistenceThread.getInstance();
    }

    public FilePersistence(IScope scope) {
        super(scope);
        this.setPath(this.path);
        this.storeThread = FilePersistenceThread.getInstance();
    }

    public void setPath(String path) {
        Resource rootFile = this.resources.getResource(path);
        try {
            this.rootDir = rootFile.getFile().getAbsolutePath();
            this.path = path;
        }
        catch (IOException err) {
            this.log.error((Object)("I/O exception thrown when setting file path to " + path));
            throw new RuntimeException(err);
        }
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    private String getObjectFilepath(IPersistable object) {
        return this.getObjectFilepath(object, false);
    }

    private String getObjectFilepath(IPersistable object, boolean completePath) {
        String name;
        int pos;
        String result = this.path + '/' + object.getType() + '/' + object.getPath();
        if (!result.endsWith("/")) {
            result = result + '/';
        }
        if (completePath && (pos = (name = object.getName()).lastIndexOf(47)) >= 0) {
            result = result + name.substring(0, pos);
        }
        return result;
    }

    protected String getObjectPath(String id, String name) {
        if (id.startsWith(this.path)) {
            id = id.substring(this.path.length() + 1);
        }
        return super.getObjectPath(id, name);
    }

    private String getObjectFilename(IPersistable object) {
        String path = this.getObjectFilepath(object);
        String name = object.getName();
        if (name == null) {
            name = "__null__";
        }
        return path + name + this.extension;
    }

    private IPersistable doLoad(String name) {
        return this.doLoad(name, null);
    }

    /*
     * Exception decompiling
     */
    private IPersistable doLoad(String name, IPersistable object) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IPersistable load(String name) {
        IPersistable result = super.load(name);
        if (result != null) {
            return result;
        }
        return this.doLoad(this.path + '/' + name + this.extension);
    }

    public boolean load(IPersistable object) {
        if (object.isPersistent()) {
            return true;
        }
        return this.doLoad(this.getObjectFilename(object), object) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveObject(IPersistable object) {
        File file;
        String path = this.getObjectFilepath(object, true);
        Resource resPath = this.resources.getResource(path);
        try {
            file = resPath.getFile();
        }
        catch (IOException err) {
            this.log.error((Object)("Could not create resource file for path " + path), (Throwable)err);
            return false;
        }
        if (!file.isDirectory() && !file.mkdirs()) {
            this.log.error((Object)("Could not create directory " + file.getAbsolutePath()));
            return false;
        }
        String filename = this.getObjectFilename(object);
        Resource resFile = this.resources.getResource(filename);
        try {
            ByteBuffer buf = ByteBuffer.allocate((int)1024);
            try {
                buf.setAutoExpand(true);
                Output out = new Output(buf);
                out.writeString(object.getClass().getName());
                object.serialize(out);
                buf.flip();
                FileOutputStream output = new FileOutputStream(resFile.getFile().getAbsolutePath());
                ServletUtils.copy(buf.asInputStream(), output);
                output.close();
            }
            finally {
                buf.release();
                buf = null;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Stored persistent object " + object + " at " + filename));
            }
            return true;
        }
        catch (IOException e) {
            this.log.error((Object)("Could not create / write file " + filename), (Throwable)e);
            return false;
        }
    }

    public boolean save(IPersistable object) {
        if (!super.save(object)) {
            return false;
        }
        this.storeThread.modified(object, this);
        object.setPersistent(true);
        return true;
    }

    protected void checkRemoveEmptyDirectories(String base) {
        File fp;
        String dir;
        if (!this.checkForEmptyDirectories) {
            return;
        }
        Resource resFile = this.resources.getResource(base.substring(0, base.lastIndexOf(47)));
        try {
            dir = resFile.getFile().getAbsolutePath();
        }
        catch (IOException err) {
            return;
        }
        while (!dir.equals(this.rootDir) && (fp = new File(dir)).isDirectory() && fp.list().length == 0 && fp.delete()) {
            dir = fp.getParent();
        }
    }

    public boolean remove(String name) {
        super.remove(name);
        String filename = this.path + '/' + name + this.extension;
        Resource resFile = this.resources.getResource(filename);
        if (!resFile.exists()) {
            return true;
        }
        try {
            boolean result = resFile.getFile().delete();
            if (result) {
                this.checkRemoveEmptyDirectories(filename);
            }
            return result;
        }
        catch (IOException err) {
            return false;
        }
    }

    public boolean remove(IPersistable object) {
        return this.remove(this.getObjectId(object));
    }

    public void notifyClose() {
        this.storeThread.notifyClose(this);
        super.notifyClose();
    }
}

