/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.persistence;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.api.persistence.IPersistable;
import org.red5.server.persistence.FilePersistence;

public class FilePersistenceThread
extends Thread {
    private Log log = LogFactory.getLog((String)FilePersistenceThread.class.getName());
    private int storeInterval = 10000;
    private Map<IPersistable, FilePersistence> modifiedObjects = new HashMap<IPersistable, FilePersistence>();
    private Map<FilePersistence, Set<IPersistable>> objectStores = new HashMap<FilePersistence, Set<IPersistable>>();
    private static volatile FilePersistenceThread instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FilePersistenceThread getInstance() {
        if (instance != null) return instance;
        Class<FilePersistenceThread> clazz = FilePersistenceThread.class;
        synchronized (FilePersistenceThread.class) {
            if (instance != null) return instance;
            instance = new FilePersistenceThread();
            instance.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private FilePersistenceThread() {
        this.setName("FilePersistenceThread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modified(IPersistable object, FilePersistence store) {
        FilePersistence previous;
        Map<IPersistable, FilePersistence> map = this.modifiedObjects;
        synchronized (map) {
            previous = this.modifiedObjects.put(object, store);
            Set<IPersistable> objects = this.objectStores.get(store);
            if (objects == null) {
                objects = new HashSet<IPersistable>();
                this.objectStores.put(store, objects);
            }
            objects.add(object);
        }
        if (previous != null && !previous.equals(store)) {
            this.log.warn((Object)("Object " + object + " was also modified in " + previous + ", saving instantly"));
            previous.saveObject(object);
            Set<IPersistable> objects = this.objectStores.get(previous);
            if (objects != null) {
                objects.remove(previous);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyClose(FilePersistence store) {
        Set<IPersistable> objects;
        Map<IPersistable, FilePersistence> map = this.modifiedObjects;
        synchronized (map) {
            objects = this.objectStores.remove(store);
            if (objects != null) {
                for (IPersistable object : objects) {
                    this.modifiedObjects.remove(object);
                }
            }
        }
        if (objects == null || objects.isEmpty()) {
            return;
        }
        for (IPersistable object : objects) {
            try {
                store.saveObject(object);
            }
            catch (Throwable e) {
                this.log.error((Object)("Error while saving " + object + " in " + store), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isAlive()) {
            long start = System.currentTimeMillis();
            if (!this.modifiedObjects.isEmpty()) {
                HashMap<IPersistable, FilePersistence> objects;
                Map<IPersistable, FilePersistence> map = this.modifiedObjects;
                synchronized (map) {
                    objects = new HashMap<IPersistable, FilePersistence>(this.modifiedObjects);
                    this.modifiedObjects.clear();
                    this.objectStores.clear();
                }
                for (Map.Entry entry : objects.entrySet()) {
                    try {
                        ((FilePersistence)entry.getValue()).saveObject((IPersistable)entry.getKey());
                    }
                    catch (Throwable e) {
                        this.log.error((Object)("Error while saving " + entry.getKey() + " in " + entry.getValue()), e);
                    }
                }
            }
            long end = System.currentTimeMillis();
            try {
                long delay = (long)this.storeInterval - (end - start);
                if (delay <= 0L) continue;
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {}
        }
    }
}

