/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.persistence;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.red5.server.api.IScope;
import org.red5.server.api.ScopeUtils;
import org.red5.server.api.persistence.IPersistable;
import org.red5.server.api.persistence.IPersistenceStore;
import org.springframework.core.io.support.ResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RamPersistence
implements IPersistenceStore {
    protected static final String PERSISTENCE_NO_NAME = "__null__";
    protected Map<String, IPersistable> objects = new ConcurrentHashMap<String, IPersistable>();
    protected ResourcePatternResolver resources;

    public RamPersistence(ResourcePatternResolver resources) {
        this.resources = resources;
    }

    public RamPersistence(IScope scope) {
        this((ResourcePatternResolver)ScopeUtils.findApplication(scope));
    }

    protected String getObjectName(String id) {
        String result = id.substring(id.lastIndexOf(47) + 1);
        if (result.equals(PERSISTENCE_NO_NAME)) {
            result = null;
        }
        return result;
    }

    protected String getObjectPath(String id, String name) {
        if ((id = id.substring(id.indexOf(47) + 1)).charAt(0) == '/') {
            id = id.substring(1);
        }
        if (id.lastIndexOf(name) <= 0) {
            return id;
        }
        return id.substring(0, id.lastIndexOf(name) - 1);
    }

    protected String getObjectId(IPersistable object) {
        String name;
        String result = object.getType();
        if (object.getPath().charAt(0) != '/') {
            result = result + '/';
        }
        if (!(result = result + object.getPath()).endsWith("/")) {
            result = result + '/';
        }
        if ((name = object.getName()) == null) {
            name = PERSISTENCE_NO_NAME;
        }
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return result + name;
    }

    @Override
    public boolean save(IPersistable object) {
        String key = this.getObjectId(object);
        this.objects.put(key, object);
        object.setPersistent(true);
        return true;
    }

    @Override
    public IPersistable load(String name) {
        return this.objects.get(name);
    }

    @Override
    public boolean load(IPersistable obj) {
        return obj.isPersistent();
    }

    @Override
    public boolean remove(IPersistable object) {
        return this.remove(this.getObjectId(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String name) {
        Map<String, IPersistable> map = this.objects;
        synchronized (map) {
            if (!this.objects.containsKey(name)) {
                return false;
            }
            IPersistable object = this.objects.remove(name);
            object.setPersistent(false);
        }
        return true;
    }

    @Override
    public Set<String> getObjectNames() {
        return this.objects.keySet();
    }

    @Override
    public Collection<IPersistable> getObjects() {
        return this.objects.values();
    }

    @Override
    public void notifyClose() {
        this.objects.clear();
    }
}

