/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.pooling;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.red5.server.jmx.JMXAgent;
import org.red5.server.pooling.ThreadObjectFactory;
import org.red5.server.pooling.ThreadPoolMBean;
import org.red5.server.pooling.WorkerThread;

public class ThreadPool
extends GenericObjectPool
implements ThreadPoolMBean {
    private static final Log log = LogFactory.getLog(ThreadPool.class);

    public ThreadPool(ThreadObjectFactory objFactory) {
        super((PoolableObjectFactory)objFactory);
        this.setWhenExhaustedAction((byte)2);
        this.setMaxIdle(2);
        this.setMaxActive(4);
        this.setMinEvictableIdleTimeMillis(30000L);
        this.setTestOnBorrow(true);
        JMXAgent.registerMBean((Object)this, this.getClass().getName(), ThreadPoolMBean.class, "threadpool");
    }

    public ThreadPool(ThreadObjectFactory objFactory, GenericObjectPool.Config config) {
        super((PoolableObjectFactory)objFactory, config);
    }

    public Object borrowObject() throws Exception {
        log.debug((Object)" borrowing object..");
        return super.borrowObject();
    }

    public synchronized WorkerThread[] borrowObjects(int num) {
        WorkerThread[] rtArr = new WorkerThread[num];
        for (int i = 0; i < num; ++i) {
            try {
                WorkerThread rt;
                rtArr[i] = rt = (WorkerThread)this.borrowObject();
                continue;
            }
            catch (Exception e) {
                log.error((Object)" borrowObjects failed.. ", (Throwable)e);
            }
        }
        return rtArr;
    }

    public void returnObject(Object obj) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)(" returning object.." + obj));
        }
        super.returnObject(obj);
    }
}

