/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.scheduling;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.jmx.JMXAgent;
import org.red5.server.scheduling.QuartzSchedulingServiceJob;
import org.red5.server.scheduling.QuartzSchedulingServiceMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzSchedulingService
implements ISchedulingService,
QuartzSchedulingServiceMBean {
    private static SchedulerFactory schedFact = new StdSchedulerFactory();
    private AtomicLong jobDetailCounter = new AtomicLong(0L);
    private Scheduler scheduler;

    public QuartzSchedulingService() {
        try {
            this.scheduler = schedFact.getScheduler();
            this.scheduler.start();
            JMXAgent.registerMBean(this, this.getClass().getName(), QuartzSchedulingServiceMBean.class);
        }
        catch (SchedulerException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String addScheduledJob(int interval, IScheduledJob job) {
        String result = this.getJobName();
        SimpleTrigger trigger = new SimpleTrigger("Trigger_" + result, null, new Date(), null, SimpleTrigger.REPEAT_INDEFINITELY, (long)interval);
        this.scheduleJob(result, (Trigger)trigger, job);
        return result;
    }

    @Override
    public String addScheduledOnceJob(Date date, IScheduledJob job) {
        String result = this.getJobName();
        SimpleTrigger trigger = new SimpleTrigger("Trigger_" + result, null, date);
        this.scheduleJob(result, (Trigger)trigger, job);
        return result;
    }

    @Override
    public String addScheduledOnceJob(long timeDelta, IScheduledJob job) {
        return this.addScheduledOnceJob(new Date(System.currentTimeMillis() + timeDelta), job);
    }

    @Override
    public String addScheduledJobAfterDelay(int interval, IScheduledJob job, int delay) {
        String result = this.getJobName();
        long startTime = System.currentTimeMillis() + (long)delay;
        SimpleTrigger trigger = new SimpleTrigger("Trigger_" + result, null, new Date(startTime), null, SimpleTrigger.REPEAT_INDEFINITELY, (long)interval);
        this.scheduleJob(result, (Trigger)trigger, job);
        return result;
    }

    @Override
    public String getJobName() {
        String result = "ScheduledJob_" + this.jobDetailCounter.getAndIncrement();
        return result;
    }

    @Override
    public List<String> getScheduledJobNames() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (String name : this.scheduler.getJobNames(null)) {
                result.add(name);
            }
        }
        catch (SchedulerException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    @Override
    public void removeScheduledJob(String name) {
        try {
            this.scheduler.deleteJob(name, null);
        }
        catch (SchedulerException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void scheduleJob(String name, Trigger trigger, IScheduledJob job) {
        JobDetail jobDetail = new JobDetail(name, null, QuartzSchedulingServiceJob.class);
        jobDetail.getJobDataMap().put((Object)"scheduling_service", (Object)this);
        jobDetail.getJobDataMap().put((Object)"scheduled_job", (Object)job);
        try {
            this.scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException ex) {
            throw new RuntimeException(ex);
        }
    }
}

