/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.script.rhino;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.script.rhino.RhinoScriptUtils;
import org.springframework.scripting.ScriptCompilationException;
import org.springframework.scripting.ScriptFactory;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.Assert;

public class RhinoScriptFactory
implements ScriptFactory {
    static Log log = LogFactory.getLog((String)RhinoScriptFactory.class.getName());
    private final String scriptSourceLocator;
    private final Class[] scriptInterfaces;
    private final Class extendedClass;

    public RhinoScriptFactory(String scriptSourceLocator) {
        Assert.hasText((String)scriptSourceLocator);
        this.scriptSourceLocator = scriptSourceLocator;
        this.scriptInterfaces = new Class[0];
        this.extendedClass = null;
    }

    public RhinoScriptFactory(String scriptSourceLocator, Class scriptInterface) {
        Assert.hasText((String)scriptSourceLocator);
        this.scriptSourceLocator = scriptSourceLocator;
        this.extendedClass = null;
        this.scriptInterfaces = null == scriptInterface ? new Class[0] : new Class[]{scriptInterface};
    }

    public RhinoScriptFactory(String scriptSourceLocator, Class[] scriptInterfaces) {
        Assert.hasText((String)scriptSourceLocator);
        this.scriptSourceLocator = scriptSourceLocator;
        this.extendedClass = null;
        this.scriptInterfaces = null == scriptInterfaces || scriptInterfaces.length < 1 ? new Class[0] : scriptInterfaces;
    }

    public RhinoScriptFactory(String scriptSourceLocator, Class[] scriptInterfaces, Class extendedClass) {
        Assert.hasText((String)scriptSourceLocator);
        Assert.notNull((Object)extendedClass);
        this.scriptSourceLocator = scriptSourceLocator;
        this.extendedClass = extendedClass;
        this.scriptInterfaces = null == scriptInterfaces || scriptInterfaces.length < 1 ? new Class[0] : scriptInterfaces;
    }

    public String getScriptSourceLocator() {
        return this.scriptSourceLocator;
    }

    public Class[] getScriptInterfaces() {
        return this.scriptInterfaces;
    }

    public boolean requiresConfigInterface() {
        return false;
    }

    public Object getScriptedObject(ScriptSource actualScriptSource, Class[] actualInterfaces) throws IOException, ScriptCompilationException {
        log.debug((Object)"Getting scripted object...");
        try {
            return RhinoScriptUtils.createRhinoObject(actualScriptSource.getScriptAsString(), actualInterfaces, this.extendedClass);
        }
        catch (Exception ex) {
            throw new ScriptCompilationException("Could not compile Rhino script: " + actualScriptSource, (Throwable)ex);
        }
    }

    public Class getScriptedObjectType(ScriptSource arg0) throws IOException, ScriptCompilationException {
        return null;
    }
}

