/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.so;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.event.IEventListener;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.red5.server.so.ISharedObjectEvent;
import org.red5.server.so.ISharedObjectMessage;
import org.red5.server.so.SharedObjectEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedObjectMessage
extends BaseEvent
implements ISharedObjectMessage {
    private String name;
    private LinkedList<ISharedObjectEvent> events = new LinkedList();
    private int version;
    private boolean persistent;

    public SharedObjectMessage(String name, int version, boolean persistent) {
        this(null, name, version, persistent);
    }

    public SharedObjectMessage(IEventListener source, String name, int version, boolean persistent) {
        super(IEvent.Type.SHARED_OBJECT, source);
        this.name = name;
        this.version = version;
        this.persistent = persistent;
    }

    @Override
    public byte getDataType() {
        return 19;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    protected void setVersion(int version) {
        this.version = version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    protected void setIsPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    @Override
    public void addEvent(ISharedObjectEvent event) {
        this.events.add(event);
    }

    public void addEvents(List<ISharedObjectEvent> events) {
        this.events.addAll(events);
    }

    public LinkedList<ISharedObjectEvent> getEvents() {
        return this.events;
    }

    @Override
    public void addEvent(ISharedObjectEvent.Type type, String key, Object value) {
        this.events.add(new SharedObjectEvent(type, key, value));
    }

    @Override
    public void clear() {
        this.events.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    @Override
    public IEvent.Type getType() {
        return IEvent.Type.SHARED_OBJECT;
    }

    @Override
    public Object getObject() {
        return this.getEvents();
    }

    @Override
    protected void releaseInternal() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SharedObjectMessage: ").append(this.name).append(" { ");
        Iterator it = this.events.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(" , ");
        }
        sb.append(" } ");
        return sb.toString();
    }
}

