/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.statistics;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.red5.server.api.IScope;
import org.red5.server.api.Red5;
import org.red5.server.api.ScopeUtils;
import org.red5.server.api.so.ISharedObject;
import org.red5.server.api.so.ISharedObjectService;
import org.red5.server.api.statistics.ISharedObjectStatistics;
import org.red5.server.api.statistics.IStatisticsService;
import org.red5.server.exception.ScopeNotFoundException;
import org.red5.server.exception.SharedObjectException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsService
implements IStatisticsService {
    private static final String SCOPE_STATS_SO_NAME = "red5ScopeStatistics";
    private static final String SO_STATS_SO_NAME = "red5SharedObjectStatistics";
    private IScope globalScope;

    public void setGlobalScope(IScope scope) {
        this.globalScope = scope;
    }

    @Override
    public ISharedObject getScopeStatisticsSO(IScope scope) {
        ISharedObjectService soService = (ISharedObjectService)ScopeUtils.getScopeService(scope, ISharedObjectService.class, false);
        return soService.getSharedObject(scope, SCOPE_STATS_SO_NAME, false);
    }

    private IScope getScope(String path) throws ScopeNotFoundException {
        IScope scope = path != null && !path.equals("") ? ScopeUtils.resolveScope(this.globalScope, path) : this.globalScope;
        if (scope == null) {
            throw new ScopeNotFoundException(this.globalScope, path);
        }
        return scope;
    }

    @Override
    public Set<String> getScopes() {
        return this.getScopes(null);
    }

    @Override
    public Set<String> getScopes(String path) throws ScopeNotFoundException {
        IScope scope = this.getScope(path);
        HashSet<String> result = new HashSet<String>();
        Iterator<String> iter = scope.getScopeNames();
        while (iter.hasNext()) {
            String name = iter.next();
            result.add(name.substring(name.indexOf(":") + 1));
        }
        return result;
    }

    @Override
    public ISharedObject getSharedObjectStatisticsSO(IScope scope) {
        ISharedObjectService soService = (ISharedObjectService)ScopeUtils.getScopeService(scope, ISharedObjectService.class, false);
        return soService.getSharedObject(scope, SO_STATS_SO_NAME, false);
    }

    @Override
    public Set<ISharedObjectStatistics> getSharedObjects(String path) {
        IScope scope = this.getScope(path);
        ISharedObjectService soService = (ISharedObjectService)ScopeUtils.getScopeService(scope, ISharedObjectService.class, false);
        HashSet<ISharedObjectStatistics> result = new HashSet<ISharedObjectStatistics>();
        for (String name : soService.getSharedObjectNames(scope)) {
            ISharedObject so = soService.getSharedObject(scope, name);
            result.add(so.getStatistics());
        }
        return result;
    }

    @Override
    public void updateScopeStatistics(String path) throws ScopeNotFoundException {
        IScope scope = this.getScope(path);
        ISharedObject so = this.getScopeStatisticsSO(Red5.getConnectionLocal().getScope());
        so.setAttribute(path, scope.getAttributes());
    }

    @Override
    public void updateSharedObjectStatistics(String path, String name) throws ScopeNotFoundException, SharedObjectException {
        IScope scope = this.getScope(path);
        ISharedObjectService soService = (ISharedObjectService)ScopeUtils.getScopeService(scope, ISharedObjectService.class, false);
        ISharedObject sourceSO = soService.getSharedObject(scope, name);
        if (sourceSO == null) {
            throw new SharedObjectException();
        }
        ISharedObject so = this.getSharedObjectStatisticsSO(Red5.getConnectionLocal().getScope());
        so.setAttribute(path + '|' + name, sourceSO.getData());
    }
}

