/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.message.Constants;

public class StreamTracker
implements Constants {
    private int lastAudio;
    private int lastVideo;
    private int lastNotify;
    private boolean relative;
    private boolean firstVideo;
    private boolean firstAudio;
    private boolean firstNotify;

    public StreamTracker() {
        this.reset();
    }

    public void reset() {
        this.lastAudio = 0;
        this.lastVideo = 0;
        this.lastNotify = 0;
        this.firstVideo = true;
        this.firstAudio = true;
        this.firstNotify = true;
    }

    public int add(IRTMPEvent event) {
        this.relative = true;
        int timestamp = event.getTimestamp();
        int tsOut = 0;
        switch (event.getDataType()) {
            case 8: {
                if (this.firstAudio) {
                    tsOut = event.getTimestamp();
                    this.relative = false;
                    this.firstAudio = false;
                } else {
                    tsOut = timestamp - this.lastAudio;
                }
                this.lastAudio = timestamp;
                break;
            }
            case 9: {
                if (this.firstVideo) {
                    tsOut = event.getTimestamp();
                    this.relative = false;
                    this.firstVideo = false;
                } else {
                    tsOut = timestamp - this.lastVideo;
                }
                this.lastVideo = timestamp;
                break;
            }
            case 18: 
            case 20: {
                if (this.firstNotify) {
                    tsOut = event.getTimestamp();
                    this.relative = false;
                    this.firstNotify = false;
                } else {
                    tsOut = timestamp - this.lastNotify;
                }
                this.lastNotify = timestamp;
                break;
            }
        }
        return tsOut;
    }

    public boolean isRelative() {
        return this.relative;
    }
}

