/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.red5.server.api.stream.IVideoStreamCodec;

public class VideoCodecFactory {
    public static final String KEY = "videoCodecFactory";
    private Log log = LogFactory.getLog((String)VideoCodecFactory.class.getName());
    private List codecs = new ArrayList();

    public void setCodecs(List codecs) {
        this.codecs = codecs;
    }

    public IVideoStreamCodec getVideoCodec(ByteBuffer data) {
        IVideoStreamCodec result = null;
        for (IVideoStreamCodec storedCodec : this.codecs) {
            IVideoStreamCodec codec;
            try {
                codec = (IVideoStreamCodec)storedCodec.getClass().newInstance();
            }
            catch (Exception e) {
                this.log.error((Object)"Could not create video codec instance.", (Throwable)e);
                continue;
            }
            this.log.info((Object)("Trying codec " + codec));
            if (!codec.canHandleData(data)) continue;
            result = codec;
            break;
        }
        return result;
    }
}

