/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream.codec;

import org.apache.mina.common.ByteBuffer;
import org.red5.server.api.stream.IVideoStreamCodec;

public class SorensonVideo
implements IVideoStreamCodec {
    static final String CODEC_NAME = "SorensonVideo";
    static final byte FLV_FRAME_KEY = 16;
    static final byte FLV_CODEC_SORENSON = 2;
    private byte[] blockData;
    private int dataCount;
    private int blockSize;

    public SorensonVideo() {
        this.reset();
    }

    public String getName() {
        return CODEC_NAME;
    }

    public boolean canDropFrames() {
        return true;
    }

    public void reset() {
        this.blockData = null;
        this.blockSize = 0;
        this.dataCount = 0;
    }

    public boolean canHandleData(ByteBuffer data) {
        if (data.limit() == 0) {
            return false;
        }
        byte first = data.get();
        boolean result = (first & 0xF) == 2;
        data.rewind();
        return result;
    }

    public boolean addData(ByteBuffer data) {
        if (data.limit() == 0) {
            return true;
        }
        if (!this.canHandleData(data)) {
            return false;
        }
        byte first = data.get();
        data.rewind();
        if ((first & 0xF0) != 16) {
            return true;
        }
        this.dataCount = data.limit();
        if (this.blockSize < this.dataCount) {
            this.blockSize = this.dataCount;
            this.blockData = new byte[this.blockSize];
        }
        data.get(this.blockData, 0, this.dataCount);
        data.rewind();
        return true;
    }

    public ByteBuffer getKeyframe() {
        if (this.dataCount == 0) {
            return null;
        }
        ByteBuffer result = ByteBuffer.allocate((int)this.dataCount);
        result.put(this.blockData, 0, this.dataCount);
        result.rewind();
        return result;
    }
}

