/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.messaging.IFilter;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IMessageComponent;
import org.red5.server.messaging.IPipe;
import org.red5.server.messaging.IPipeConnectionListener;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.messaging.PipeConnectionEvent;

public class StreamBandwidthController
implements IFilter,
IPipeConnectionListener,
Runnable {
    private static final Log log = LogFactory.getLog(StreamBandwidthController.class);
    public static final String KEY = StreamBandwidthController.class.getName();
    private IPipe providerPipe;
    private IPipe consumerPipe;
    private Thread puller;
    private boolean isStarted;

    public void onPipeConnectionEvent(PipeConnectionEvent event) {
        switch (event.getType()) {
            case 0: {
                if (event.getProvider() == this || this.providerPipe != null) break;
                this.providerPipe = (IPipe)event.getSource();
                break;
            }
            case 2: {
                if (event.getSource() != this.providerPipe) break;
                this.providerPipe = null;
                break;
            }
            case 4: {
                if (event.getConsumer() == this || this.consumerPipe != null) break;
                this.consumerPipe = (IPipe)event.getSource();
                break;
            }
            case 5: {
                if (event.getSource() != this.consumerPipe) break;
                this.consumerPipe = null;
                break;
            }
        }
    }

    public void onOOBControlMessage(IMessageComponent source, IPipe pipe, OOBControlMessage oobCtrlMsg) {
    }

    public void run() {
        while (this.isStarted && this.providerPipe != null && this.consumerPipe != null) {
            try {
                IMessage message = this.providerPipe.pullMessage();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("got message: " + message));
                }
                this.consumerPipe.pushMessage(message);
            }
            catch (Exception e) {
                // empty catch block
                break;
            }
        }
        this.isStarted = false;
    }

    public void start() {
        this.startThread();
    }

    public void close() {
        this.isStarted = false;
    }

    private synchronized void startThread() {
        if (!this.isStarted && this.providerPipe != null && this.consumerPipe != null) {
            this.puller = new Thread(this);
            this.puller.setDaemon(true);
            this.isStarted = true;
            this.puller.start();
        }
    }
}

