/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.war;

import java.rmi.Naming;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.log4j.Logger;
import org.red5.server.war.IRemotableList;
import org.red5.server.war.RemotableList;
import org.red5.server.war.RootContextLoaderServlet;
import org.red5.server.war.WebSettings;

public class SubContextLoaderServlet
extends RootContextLoaderServlet {
    private static final long serialVersionUID = 41919712007L;
    public static Logger logger = Logger.getLogger((String)SubContextLoaderServlet.class.getName());
    private static ServletContext servletContext;

    public void contextInitialized(ServletContextEvent sce) {
        if (null != servletContext) {
            return;
        }
        System.setProperty("red5.deployment.type", "war");
        servletContext = sce.getServletContext();
        String prefix = servletContext.getRealPath("/");
        this.initRegistry(servletContext);
        long time = System.currentTimeMillis();
        logger.info((Object)"RED5 Server subcontext loader");
        logger.debug((Object)("Path: " + prefix));
        try {
            String[] configArray = servletContext.getInitParameter("contextConfigLocation").split("[,\\s]");
            logger.debug((Object)("Config location files: " + configArray.length));
            WebSettings settings = new WebSettings();
            settings.setPath(prefix);
            String[] subConfigs = new String[configArray.length];
            for (int s = 0; s < configArray.length; ++s) {
                String cfg = "file:/" + prefix + configArray[s];
                logger.debug((Object)("Sub config location: " + cfg));
                subConfigs[s] = cfg;
            }
            settings.setConfigs(subConfigs);
            settings.setWebAppKey(servletContext.getInitParameter("webAppRootKey"));
            IRemotableList remote = null;
            boolean firstReg = false;
            try {
                remote = (IRemotableList)Naming.lookup("rmi://localhost:" + this.rmiPort + "/subContextList");
            }
            catch (Exception e) {
                logger.warn((Object)("Lookup failed: " + e.getMessage()));
            }
            if (remote == null) {
                remote = new RemotableList();
                firstReg = true;
            }
            logger.debug((Object)"Adding child web settings");
            remote.addChild(settings);
            logger.debug((Object)("Remote list size: " + remote.numChildren()));
            if (firstReg) {
                Naming.bind("rmi://localhost:" + this.rmiPort + "/subContextList", remote);
            } else {
                Naming.rebind("rmi://localhost:" + this.rmiPort + "/subContextList", remote);
            }
        }
        catch (Throwable t) {
            logger.error((Object)t);
        }
        long startupIn = System.currentTimeMillis() - time;
        logger.info((Object)("Startup done in: " + startupIn + " ms"));
    }
}

