<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * bookmark class
 *
 * PHP version 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_0.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     gooooooogle, shoma
 * @copyright  2006 gooooooogle, shoma
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */

/**
 * bookmark class
 *
 * This is bookmark class.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     gooooooogle, shoma
 * @copyright  2006 gooooooogle, shoma
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */
class Services_Hatena_bookmark extends Services_Hatena_base {
    private   $http;
    private   $addurl  = 'http://b.hatena.ne.jp/atom/post';
    private   $editurl = 'http://b.hatena.ne.jp/atom/edit';
    protected $parameters;

    public function Services_Hatena_bookmark()
    {
        $this->http = new HTTP_Request();
    }

    public function add_bookmark($url, $comment) {
        mb_internal_encoding('euc');
        require_once "HTTP/Request.php";

        $wsse    = $this->getWSSEAuth();

        $rawdata = '
<entry xmlns="http://purl.org/atom/ns#">
<title>PAGE\'S TITLE</title>
<link rel="related" type="text/html" href="'.$url.'" />
<summary type="text/plain">'.$comment.'</summary>
</entry>';

        $this->setHeader(HTTP_REQUEST_METHOD_POST, $this->addurl);
        $this->http->addRawPostData($rawdata);

        $this->result = $this->http->sendRequest();
    }

    public function get_bookmark($eid) {
        mb_internal_encoding('euc');
        require_once "HTTP/Request.php";

        $this->setHeader(HTTP_REQUEST_METHOD_GET, $this->editurl . "/$eid");

        $res = $this->http->sendRequest();
        $local_result = $this->http->getResponseBody();

        $matches = array();
        $pattern = '/<title>(.*)<\/title>/';
        preg_match($pattern, $local_result, $matches);

        $this->result = $matches[1];
    }

    public function edit_bookmark($eid, $title, $comment) {
        mb_internal_encoding('euc');
        require_once "HTTP/Request.php";

        $rawdata = '
<entry xmlns="http://purl.org/atom/ns#">
<title>'.$title.'</title>
<summary type="text/plain">'.$comment.'</summary>
</entry>';


        $this->setHeader(HTTP_REQUEST_METHOD_PUT, $this->editurl . "/$eid");
        $this->http->addRawPostData($rawdata);

        $this->result = $this->http->sendRequest();
    }

    public function delete_bookmark($eid) {
        mb_internal_encoding('euc');
        require_once "HTTP/Request.php";

        $this->setHeader(HTTP_REQUEST_METHOD_DELETE, $this->editurl . "/$eid");
        $this->http->addRawPostData($rawdata);

        $this->result = $this->http->sendRequest();
    }

    private function setHeader($method, $url) {
        $this->http->addHeader('Accept', 'application/x.atom+xml, application/xml, text/xml, */*');
        $this->http->addHeader('Authorization', 'WSSE profile="UsernameToken"');
        $this->http->addHeader('X-WSSE', $this->getWSSEAuth());
        $this->http->addHeader('Content-Type', 'application/x.atom+xml');
        $this->http->setMethod($method);
        $this->http->setURL($url);
    }
}
