#include "suppon.h"

DWORD GetInt(VARIANTARG* rgvarg, int* i){
	if (rgvarg->vt & VT_BYREF) rgvarg=rgvarg->pvarVal;
	switch(rgvarg->vt){
		case VT_I1: case VT_UI1:
			*i=(int)rgvarg->bVal;
			break;
		case VT_I2:
			*i=(int)rgvarg->iVal;
			break;
		case VT_I4:
			*i=(int)rgvarg->lVal;
			break;
		case VT_R4:
			*i=(int)rgvarg->fltVal;
			break;
		case VT_R8:
			*i=(int)rgvarg->dblVal;
			break;
		default:
			return DISP_E_BADVARTYPE;
	}
	return S_OK;
}

class SupponClass : public IDispatch {
private:
	DWORD ref;
public:
	SupponClass(){
		ref=1;
	}
	// These methods not implemented
	STDMETHOD(GetTypeInfoCount)(UINT* pctinfo){ return E_NOTIMPL;  }
	STDMETHOD(GetTypeInfo)(UINT, LCID, ITypeInfo**){ return E_NOTIMPL;  }

	// Basic IDispatch imprementation
	STDMETHOD(QueryInterface)(REFIID riid, void** ppvObject){
		if ((riid != IID_IUnknown) && (riid != IID_IDispatch)) return E_NOINTERFACE;
		*ppvObject=this;
		ref++;
		return S_OK;
	}
	STDMETHOD_(ULONG,AddRef)(){ return ++ref; }
	STDMETHOD_(ULONG,Release)(){ return --ref; }

	//Method definition
	STDMETHOD(GetIDsOfNames)(REFIID, LPOLESTR* rgszNames,
			   UINT cNames, LCID, DISPID* rgDispId)
	{
		for (UINT i = 0; i < cNames; i++){
			rgDispId[i] = DISPID_UNKNOWN;
			if (!lstrcmpiW(rgszNames[i],L"CreateObject")) rgDispId[i]=1;
			else if (!lstrcmpiW(rgszNames[i],L"Quit"))    rgDispId[i]=2;
			else if (!lstrcmpiW(rgszNames[i],L"Sleep"))   rgDispId[i]=3;
			else return DISP_E_MEMBERNOTFOUND;
		}
		return S_OK;
	}

	//Method Invoke
	STDMETHOD(Invoke)(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags,
			DISPPARAMS* pDispParams, VARIANT* pVarResult,
			EXCEPINFO* pExcepInfo, UINT *puArgErr)
	{
		int cArgs = pDispParams->cArgs;
		VARIANTARG* rgvarg = pDispParams->rgvarg;
		int i;
		DWORD ret;
		switch (dispIdMember){
		case 1: // CreateObject
			if (cArgs!=2) return DISP_E_BADPARAMCOUNT;
			if (rgvarg[0].vt!=VT_BSTR || rgvarg[1].vt!=VT_BSTR) return DISP_E_BADVARTYPE;
			if (!pVarResult) return S_OK;
			pVarResult->pdispVal=CreateObject(rgvarg[1].bstrVal,rgvarg[0].bstrVal);
			if (!pVarResult->pdispVal) return CS_E_OBJECT_NOTFOUND;
			pVarResult->vt=VT_DISPATCH;
			return S_OK;

		case 2: // Quit
			SupponQuit quit;
			switch(cArgs){
				case 0:
					quit.e=0;
					break;
				case 1:
					ret=GetInt(&rgvarg[0], &quit.e);
					if (ret!=S_OK) return ret;
					break;
				default:
					return DISP_E_BADPARAMCOUNT;
			}
			try{ // A dummy try statement to avoid warning when the compile
				throw quit; // jump to WinMain
			} catch (int) {}
			return S_OK;

		case 3: // Sleep
			if (cArgs!=1) return DISP_E_BADPARAMCOUNT;
			ret=GetInt(rgvarg, &i);
			if (ret!=S_OK) return ret;
			SleepEx(i,true);
			return S_OK;

		default:
			return (DWORD)DISPID_UNKNOWN;
		}
	}
};

IDispatch* SupponObject(){
	return (IDispatch*) new SupponClass;
}