/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.Convert;
import com.sybase.jdbc4.jdbc.DateObject;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.LimiterInputStream;
import com.sybase.jdbc4.jdbc.Param;
import com.sybase.jdbc4.jdbc.ParamManager;
import com.sybase.jdbc4.jdbc.ProtocolContext;
import com.sybase.jdbc4.jdbc.ProtocolResultSet;
import com.sybase.jdbc4.jdbc.SybCursorResultSet;
import com.sybase.jdbc4.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc4.jdbc.SybPreparedStatement;
import com.sybase.jdbc4.jdbc.SybScrollCursorResultSet;
import com.sybase.jdbc4.utils.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SybCallableStatement
extends SybPreparedStatement
implements com.sybase.jdbcx.SybCallableStatement {
    protected boolean _hasOutParam = false;

    SybCallableStatement(ProtocolContext protocolContext, String string) throws SQLException {
        super(protocolContext, string, 2);
        this._sqlStr = string;
        if (this._hasReturn) {
            this._paramMgr.doSetParam(1, -998, new Integer(0), 0);
            this._paramMgr.doRegisterParam(1, 4);
            this._returnHasBeenRegistered = false;
        }
    }

    SybCallableStatement(ProtocolContext protocolContext, SybCallableStatement sybCallableStatement) throws SQLException {
        super(protocolContext, sybCallableStatement);
        this._allowsOutputParms = sybCallableStatement._allowsOutputParms;
        this._rpcName = sybCallableStatement._rpcName;
        this._sendAsRpc = sybCallableStatement._sendAsRpc;
        this._hasReturn = sybCallableStatement._hasReturn;
        if (this._hasReturn) {
            this._paramMgr.doSetParam(1, -998, new Integer(0), 0);
            this._paramMgr.doRegisterParam(1, 4);
            this._returnHasBeenRegistered = false;
        }
    }

    @Override
    protected void setDoEscapes() {
        this._doEscapes = true;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.clearParams();
        if (this._sendAsRpc) {
            this.checkStatement(true);
            if (this.sendRpc(this._rpcName, this._paramMgr)) {
                return this.queryLoop();
            }
            return this._currentRS;
        }
        return super.executeQuery(this._query, this._paramMgr);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.clearParams();
        int n2 = -1;
        if (this._sendAsRpc) {
            this.checkStatement(true);
            if (this._cursor != null) {
                ErrorMessage.raiseError("JZ0S3");
            }
            if (this.sendRpc(this._rpcName, this._paramMgr)) {
                n2 = this.updateLoop();
            }
        } else {
            n2 = super.executeUpdate(this._query, this._paramMgr);
        }
        return n2;
    }

    @Override
    public boolean execute() throws SQLException {
        this.clearParams();
        if (this._sendAsRpc) {
            this.checkStatement(true);
            if (this.sendRpc(this._rpcName, this._paramMgr)) {
                return this.executeLoop();
            }
            return this._currentRS != null;
        }
        return super.execute(this._query, this._paramMgr);
    }

    @Override
    public void addBatch() throws SQLException {
        if (this._batchCmdsCount < 1) {
            this._query = this.handleCallBody(this._query);
        }
        super.addBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this._hasReturn || this._hasOutParam) {
            ErrorMessage.raiseError("JZ0BP");
        }
        return super.executeBatch();
    }

    @Override
    public void cancel() throws SQLException {
        this.checkStatement(false);
        try {
            this._paramMgr.clearParams(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.cancel();
    }

    @Override
    public void registerOutParameter(int n2, int n3) throws SQLException {
        this.do(n2);
        this._paramMgr.registerParam(n2, n3);
    }

    @Override
    public void registerOutParameter(String string, int n2) throws SQLException {
        this._paramMgr.registerParam(string, n2);
    }

    @Override
    public void registerOutParameter(int n2, int n3, int n4) throws SQLException {
        this.do(n2);
        this._paramMgr.registerParam(n2, n3, n4);
    }

    @Override
    public void registerOutParameter(String string, int n2, int n3) throws SQLException {
        this._paramMgr.registerParam(string, n2, n3);
    }

    @Override
    public void registerOutParameter(int n2, int n3, String string) throws SQLException {
        this._paramMgr.registerParam(n2, n3, string);
    }

    @Override
    public void registerOutParameter(String string, int n2, String string2) throws SQLException {
        this._paramMgr.registerParam(string, n2, string2);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this._paramMgr.wasNull();
    }

    @Override
    public String getString(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getString();
    }

    @Override
    public String getString(String string) throws SQLException {
        return this._paramMgr.getOutValueAt(string).getString();
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        this.a(12, string, string2);
    }

    @Override
    public boolean getBoolean(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getBoolean();
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this._paramMgr.getOutValueAt(string).getBoolean();
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        Boolean bl2 = new Boolean(bl);
        this.a(-7, string, bl2);
    }

    @Override
    public byte getByte(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getByte();
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this._paramMgr.getOutValueAt(string).getByte();
    }

    @Override
    public void setByte(String string, byte by) throws SQLException {
        Integer n2 = new Integer(by);
        if (n2 < 0) {
            this.a(5, string, n2);
        } else {
            this.a(-6, string, n2);
        }
    }

    @Override
    public short getShort(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getShort();
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this._paramMgr.getOutValueAt(string).getShort();
    }

    @Override
    public void setShort(String string, short s2) throws SQLException {
        Integer n2 = new Integer(s2);
        this.a(5, string, n2);
    }

    @Override
    public int getInt(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getInt();
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this._paramMgr.getOutValueAt(string).getInt();
    }

    @Override
    public void setInt(String string, int n2) throws SQLException {
        Integer n3 = new Integer(n2);
        this.a(4, string, n3);
    }

    @Override
    public long getLong(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getLong();
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this._paramMgr.getOutValueAt(string).getLong();
    }

    @Override
    public void setLong(String string, long l2) throws SQLException {
        Long l3 = new Long(l2);
        this.a(-5, string, l3);
    }

    @Override
    public float getFloat(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getFloat();
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this._paramMgr.getOutValueAt(string).getFloat();
    }

    @Override
    public void setFloat(String string, float f2) throws SQLException {
        Float f3 = new Float(f2);
        this.a(7, string, f3);
    }

    @Override
    public double getDouble(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getDouble();
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this._paramMgr.getOutValueAt(string).getDouble();
    }

    @Override
    public void setDouble(String string, double d2) throws SQLException {
        Double d3 = new Double(d2);
        this.a(8, string, d3);
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getBigDecimal(n3);
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        return this.getBigDecimal(n2, -1);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this._paramMgr.getOutValueAt(string).getBigDecimal(-1);
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.setNull(string, 2);
        } else {
            this.a(2, string, bigDecimal, bigDecimal.scale());
        }
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getBytes();
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this._paramMgr.getOutValueAt(string).getBytes();
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        int n2 = 0;
        if (byArray != null) {
            n2 = byArray.length;
        }
        if (n2 > 255) {
            this.a(-4, string, byArray);
        } else {
            this.a(-3, string, byArray);
        }
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        return Convert.objectToDate(this._paramMgr.getOutValueAt(n2).getDateObject(91, null));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return Convert.objectToDate(this._paramMgr.getOutValueAt(string).getDateObject(91, null));
    }

    @Override
    public void setDate(String string, Date date) throws SQLException {
        if (date == null) {
            this.a(91, string, date);
        } else {
            this.a(91, string, new DateObject((Object)date, 91));
        }
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        return Convert.objectToTime(this._paramMgr.getOutValueAt(n2).getDateObject(92, null));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return Convert.objectToTime(this._paramMgr.getOutValueAt(string).getDateObject(92, null));
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        if (time == null) {
            this.a(92, string, time);
        } else {
            this.a(92, string, new DateObject((Object)time, 92));
        }
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        return Convert.objectToTimestamp(this._paramMgr.getOutValueAt(n2).getDateObject(93, null));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return Convert.objectToTimestamp(this._paramMgr.getOutValueAt(string).getDateObject(93, null));
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.a(93, string, timestamp);
        } else {
            this.a(93, string, new DateObject((Object)timestamp, 93));
        }
    }

    @Override
    public Object getObject(int n2) throws SQLException {
        return this._paramMgr.getOutObjectAt(n2);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this._paramMgr.getOutObjectAt(string);
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        if (object == null) {
            ErrorMessage.raiseError("JZ0SE");
        }
        if (object instanceof Short) {
            this.setShort(string, (short)((Short)object));
        } else if (object instanceof Byte) {
            this.setByte(string, (byte)((Byte)object));
        } else if (object instanceof String) {
            this.setString(string, (String)object);
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(string, (BigDecimal)object);
        } else if (object instanceof Boolean) {
            this.a(-7, string, object);
        } else if (object instanceof Integer) {
            this.a(4, string, object);
        } else if (object instanceof Long) {
            this.a(-5, string, object);
        } else if (object instanceof Float) {
            this.a(7, string, object);
        } else if (object instanceof Double) {
            this.a(8, string, object);
        } else if (object instanceof byte[]) {
            this.setBytes(string, (byte[])object);
        } else if (object instanceof Date) {
            this.setDate(string, (Date)object);
        } else if (object instanceof Time) {
            this.setTime(string, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(string, (Timestamp)object);
        } else if (object instanceof Serializable) {
            this.a(2000, string, object);
        } else {
            ErrorMessage.raiseError("JZ0SE");
        }
    }

    @Override
    public void setObject(String string, Object object, int n2) throws SQLException {
        this.setObject(string, object, n2, 0);
    }

    @Override
    public void setObject(String string, Object object, int n2, int n3) throws SQLException {
        if (object == null) {
            this.a(n2, string, null, n3);
        }
        switch (n2) {
            case -7: {
                this.a(n2, string, Convert.objectToBoolean(object), n3);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                this.a(n2, string, Convert.objectToInt(object), n3);
                break;
            }
            case -5: {
                this.a(n2, string, Convert.objectToLong(object), n3);
                break;
            }
            case 1: 
            case 12: {
                this.setString(string, Convert.objectToString(object));
                break;
            }
            case -15: 
            case -9: {
                this.setNString(string, Convert.objectToString(object));
                break;
            }
            case -1: {
                this.a(-1, string, Convert.objectToString(object));
                break;
            }
            case 2: 
            case 3: {
                if (n3 < 0) {
                    ErrorMessage.raiseError("JZ00I");
                }
                this.a(n2, string, Convert.objectToBigDecimal(object), n3);
                break;
            }
            case 7: {
                this.a(n2, string, Convert.objectToFloat(object), n3);
                break;
            }
            case 6: 
            case 8: {
                this.a(n2, string, Convert.objectToDouble(object), n3);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(string, Convert.objectToBytes(object));
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                this.a(n2, string, Convert.objectToDateObject(object, n2, null), n3);
                break;
            }
            case 1111: 
            case 2000: {
                if (object instanceof Serializable || object == null) {
                    this.a(2000, string, object);
                    break;
                }
            }
            default: {
                ErrorMessage.raiseError("JZ0SE");
            }
        }
    }

    public boolean sendRpc(String string, ParamManager paramManager) throws SQLException {
        try {
            if (this._rsConcur == -9) {
                this._rsConcur = 1007;
            }
            if (this._rsConcur == 1008) {
                this.checkCursor(false);
            }
            if (this._cursor != null) {
                ProtocolResultSet protocolResultSet = this._cursor.open(string, paramManager, true);
                protocolResultSet.setType(this._rsType);
                this._currentRS = this._cursor.scrollingAtServer() ? new SybScrollCursorResultSet(this, protocolResultSet) : new SybCursorResultSet(this, protocolResultSet);
                this._context._conn.addCursorResultSet(this._cursor.getName(), this._currentRS);
                this._state = 2;
                return false;
            }
            this._protocol.rpc(this._context, string, paramManager);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return true;
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        Debug.notSupported(this, "getRef(int)");
        return null;
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        Debug.notSupported(this, "getRef(String)");
        return null;
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        Debug.notSupported(this, "getBlob(int)");
        return null;
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        Debug.notSupported(this, "getBlob(String)");
        return null;
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        Debug.notSupported(this, "getClob(int)");
        return null;
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        Debug.notSupported(this, "getClob(String)");
        return null;
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        Debug.notSupported(this, "getArray(int)");
        return null;
    }

    @Override
    public Array getArray(String string) throws SQLException {
        Debug.notSupported(this, "getArray(String)");
        return null;
    }

    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        return Convert.objectToDate(this._paramMgr.getOutValueAt(n2).getDateObject(91, calendar));
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return Convert.objectToDate(this._paramMgr.getOutValueAt(string).getDateObject(91, calendar));
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        if (date == null) {
            this.a(91, string, date);
        } else {
            this.a(91, string, new DateObject(date, calendar, 91));
        }
    }

    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        return Convert.objectToTime(this._paramMgr.getOutValueAt(n2).getDateObject(92, calendar));
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return Convert.objectToTime(this._paramMgr.getOutValueAt(string).getDateObject(92, calendar));
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        if (time == null) {
            this.a(92, string, time);
        } else {
            this.a(92, string, new DateObject(time, calendar, 92));
        }
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return Convert.objectToTimestamp(this._paramMgr.getOutValueAt(n2).getDateObject(93, calendar));
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return Convert.objectToTimestamp(this._paramMgr.getOutValueAt(string).getDateObject(93, calendar));
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (timestamp == null) {
            this.a(93, string, timestamp);
        } else {
            this.a(93, string, new DateObject(timestamp, calendar, 93));
        }
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        Debug.notSupported(this, "getURL(int)");
        return null;
    }

    @Override
    public URL getURL(String string) throws SQLException {
        Debug.notSupported(this, "getURL(String)");
        return null;
    }

    @Override
    public void setURL(String string, URL uRL) throws SQLException {
        Debug.notSupported(this, "setURL(String, URL)");
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(string, -1);
        } else {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new LimiterInputStream(inputStream, n2), "ISO8859_1");
                this.a(-1, string, inputStreamReader, n2);
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
        }
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.a(-4, string, inputStream, n2);
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.a(-1, string, reader, n2);
    }

    @Override
    public void setNull(String string, int n2) throws SQLException {
        this.a(n2, string, null);
    }

    @Override
    public void setNull(String string, int n2, String string2) throws SQLException {
        Debug.notImplemented(this, "setNull(String, int, String)");
    }

    public void clearParams() throws SQLException {
        try {
            this._paramMgr.clearParams(false);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    @Override
    protected void handleParam(ParamManager paramManager) throws SQLException {
        if (this._batchCmds == null) {
            this._paramMgr.getParameter();
        } else {
            paramManager.getParameter();
        }
    }

    private void do(int n2) throws SQLException {
        if (!this._allowsOutputParms) {
            ErrorMessage.raiseError("JZ0SB", String.valueOf(n2));
        }
    }

    @Override
    public void setParameterName(int n2, String string) {
        Param[] paramArray = this._paramMgr.getParams();
        if (paramArray.length >= n2 && n2 > 0) {
            paramArray[n2 - 1]._name = string;
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            if (this._dbmda == null) {
                this._dbmda = (SybDatabaseMetaData)this._context._conn.getMetaData();
            }
            if (this._dbmda.getDatabaseProductName().indexOf("Anywhere") != -1) {
                return null;
            }
        }
        catch (SQLException sQLException) {
            return null;
        }
        SybCallableStatement sybCallableStatement = new SybCallableStatement(this._context, "{call sp_jdbc_getprocedurecolumns (@sp_name=?, @parammetadata=1, @paramcolids=?, @paramnames=?)}");
        if (this._paramMgr.getParamSetType() == 1) {
            this._paramNames = this._paramMgr.getColumnNames();
            this._paramColids = this._hasReturn ? "0" : null;
        }
        sybCallableStatement.setString(1, this._rpcName);
        sybCallableStatement.setString(2, this._paramColids);
        sybCallableStatement.setString(3, this._paramNames);
        ResultSet resultSet = sybCallableStatement.executeQuery();
        this._paramMgr.setParamMd(resultSet);
        return this;
    }

    private void a(int n2, String string, Object object) throws SQLException {
        this.a(n2, string, object, 0);
    }

    private void a(int n2, String string, Object object, int n3) throws SQLException {
        this._paramMgr.setParam(string, n2, object, n3);
    }

    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getCharacterStream();
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this._paramMgr.getOutValueAt(string).getCharacterStream();
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getCharacterStream();
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this._paramMgr.getOutValueAt(string).getCharacterStream();
    }

    @Override
    public String getNString(int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n2).getString();
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this._paramMgr.getOutValueAt(string).getString();
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        this.a(-9, string, string2);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        this.a(-1, string, reader, -1);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        int n2 = this.checkLongLength(l2);
        this.a(-1, string, reader, n2);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.setAsciiStream(string, inputStream, -1);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        if (inputStream == null) {
            this.setNull(string, -1);
        } else {
            int n2 = this.checkLongLength(l2);
            this.setAsciiStream(string, inputStream, n2);
        }
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.a(-4, string, inputStream, -1);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        int n2 = this.checkLongLength(l2);
        this.a(-4, string, inputStream, n2);
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        this.a(-1, string, reader, -1);
    }

    @Override
    public void setCharacterStream(String string, Reader reader, long l2) throws SQLException {
        int n2 = this.checkLongLength(l2);
        this.a(-1, string, reader, n2);
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        Debug.notImplemented(this, "public RowId getRowId(int arg0)");
        return null;
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        Debug.notImplemented(this, "public RowId getRowId(String arg0)");
        return null;
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        Debug.notImplemented(this, "public SQLXML getSQLXML(int arg0)");
        return null;
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        Debug.notImplemented(this, "public SQLXML getSQLXML(String arg0)");
        return null;
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        Debug.notImplemented(this, "public void setBlob(String arg0, Blob arg1)");
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        Debug.notImplemented(this, "public void setBlob(String arg0, InputStream arg1)");
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l2) throws SQLException {
        Debug.notImplemented(this, "public void setBlob(String arg0, InputStream arg1, long arg2)");
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        Debug.notImplemented(this, "public void setClob(String arg0, Clob arg1)");
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        Debug.notImplemented(this, "public void setClob(String arg0, Reader arg1)");
    }

    @Override
    public void setClob(String string, Reader reader, long l2) throws SQLException {
        Debug.notImplemented(this, "public void setClob(String arg0, Reader arg1, long arg2)");
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "setNClob(String, NClob)");
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "setNClob(String, Reader)");
    }

    @Override
    public void setNClob(String string, Reader reader, long l2) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "setNClob(String, Reader, long)");
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        Debug.notImplemented(this, "public void setRowId(String arg0, RowId arg1)");
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        Debug.notImplemented(this, "public void setSQLXML(String arg0, SQLXML arg1)");
    }

    public Object getObject(int n2, Map map) throws SQLException {
        Debug.notImplemented(this, "public Object getObject(int arg0, Map<String, Class<?>> arg1)");
        return null;
    }

    public Object getObject(String string, Map map) throws SQLException {
        Debug.notImplemented(this, "public Object getObject(String arg0, Map<String, Class<?>> arg1)");
        return null;
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getNClob(int)");
        return null;
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getNClob(String)");
        return null;
    }
}

