/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.ParamManager;
import com.sybase.jdbc4.jdbc.Protocol;
import com.sybase.jdbc4.tds.DataFormat;
import com.sybase.jdbc4.tds.RowFormatToken;
import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.tds.TdsOutputStream;
import com.sybase.jdbc4.tds.TdsParam;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

public class ParamFormatToken
extends RowFormatToken {
    public static final int MAX_PARAMFMT_LENGTH = 65535;
    protected DataFormat[] _param;
    protected ParamManager _paramMgr;
    protected int _numParams;
    private int _length = -1;

    public ParamFormatToken() {
    }

    public ParamFormatToken(ParamManager paramManager) throws IOException, SQLException {
        this._numParams = paramManager.makeFormats();
        this._paramMgr = paramManager;
    }

    public ParamFormatToken(TdsInputStream tdsInputStream) throws IOException {
        this.readLength(tdsInputStream);
        this._numColumns = tdsInputStream.readShort();
        this.addDataFormats(tdsInputStream, this._numColumns);
    }

    public ParamFormatToken(ArrayList arrayList, Protocol protocol) throws IOException, SQLException {
        TdsParam tdsParam = null;
        this._length = 0;
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            tdsParam = (TdsParam)arrayList.get(i2);
            if (!tdsParam.makeFormat(protocol)) continue;
            this._length += tdsParam._inDataFmt.length();
            ++this._numParams;
        }
    }

    protected long getLength() {
        int n2 = 2;
        n2 = this._length < 0 ? (n2 += this._paramMgr.getLength()) : (n2 += this._length);
        return n2;
    }

    public int getFormatCount() {
        return this._numParams;
    }

    @Override
    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        if (this.getLength() > 65535L) {
            ErrorMessage.raiseIOException("JZ0PC");
        } else {
            tdsOutputStream.writeByte(236);
            tdsOutputStream.writeShort((int)this.getLength());
            tdsOutputStream.writeShort(this.getFormatCount());
            this.sendFormat(tdsOutputStream);
        }
    }

    protected void sendFormat(TdsOutputStream tdsOutputStream) throws IOException {
        this._paramMgr.sendFormats(tdsOutputStream);
    }

    public void sendAddBatch(ArrayList arrayList, TdsOutputStream tdsOutputStream) throws IOException {
        long l2 = this.getLength();
        if (l2 > 65535L) {
            ErrorMessage.raiseIOException("JZ0PC");
        } else {
            tdsOutputStream.writeByte(236);
            tdsOutputStream.writeShort((int)l2);
            tdsOutputStream.writeShort(this.getFormatCount());
            TdsParam tdsParam = null;
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                tdsParam = (TdsParam)arrayList.get(i2);
                tdsParam.sendFormat(tdsOutputStream);
            }
        }
    }
}

