/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.jdbc.DateObject;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.JdbcDataObject;
import com.sybase.jdbc4.jdbc.TextPointer;
import com.sybase.jdbc4.tds.DataFormat;
import com.sybase.jdbc4.tds.Tds;
import com.sybase.jdbc4.tds.TdsDataInputStream;
import com.sybase.jdbc4.tds.TdsDateTime;
import com.sybase.jdbc4.tds.TdsNumeric;
import com.sybase.jdbc4.tds.TdsProtocolContext;
import com.sybase.jdbc4.utils.Chainable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Calendar;

public abstract class TdsDataObject
extends TdsDataInputStream
implements JdbcDataObject,
Chainable {
    public static final int UNKNOWN = -1;
    public static final int UNINITIALIZED = -2;
    protected TdsProtocolContext _context;
    protected int _state;
    protected DataFormat _dataFmt;
    protected boolean _isNull;
    protected int _dataLength = -2;
    protected byte _columnStatus;
    protected boolean _holds0LNN = false;
    protected int _textptrlen = 0;
    protected byte[] _textptr = null;
    protected byte[] _timestamp = null;
    protected int _classIDLen;
    protected byte[] _classID;
    protected int _dbID;
    protected int _classNum;
    TdsDataObject _next = null;
    TdsDataObject _prev = null;

    public TdsDataObject(TdsProtocolContext tdsProtocolContext) throws IOException {
        super((Tds)tdsProtocolContext._protocol, tdsProtocolContext._inFormat);
        this._context = tdsProtocolContext;
        this.setBigEndian(tdsProtocolContext._bigEndian);
        this.initialize();
    }

    protected abstract TdsDataObject createCachedCopy() throws IOException, SQLException;

    protected void copyInto(TdsDataObject tdsDataObject) throws IOException {
        tdsDataObject._state = this._state;
        tdsDataObject._dataFmt = this._dataFmt;
        tdsDataObject._isNull = this._isNull;
        tdsDataObject._dataLength = this._dataLength;
        tdsDataObject._textptrlen = this._textptrlen;
        tdsDataObject._classIDLen = this._classIDLen;
        tdsDataObject._dbID = this._dbID;
        tdsDataObject._classNum = this._classNum;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.badConversionCombination();
        return null;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.badConversionCombination();
        return null;
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        this.badConversionCombination();
        return null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.badConversionCombination();
        return null;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        this.badConversionCombination();
        return null;
    }

    @Override
    public DateObject getDateObject(int n2, Calendar calendar) throws SQLException {
        this.badConversionCombination();
        return null;
    }

    @Override
    public TextPointer getTextPtr() throws SQLException {
        this.noTextPointer();
        return null;
    }

    @Override
    public abstract BigDecimal getBigDecimal(int var1) throws SQLException;

    @Override
    public abstract boolean getBoolean() throws SQLException;

    @Override
    public abstract byte getByte() throws SQLException;

    @Override
    public abstract double getDouble() throws SQLException;

    @Override
    public abstract float getFloat() throws SQLException;

    @Override
    public abstract int getInt() throws SQLException;

    @Override
    public abstract long getLong() throws SQLException;

    @Override
    public abstract short getShort() throws SQLException;

    @Override
    public abstract Object getObject() throws SQLException;

    @Override
    public abstract String getString() throws SQLException;

    @Override
    public boolean isNull() throws SQLException {
        return this._isNull;
    }

    @Override
    public void setNext(Chainable chainable) {
        this._next = (TdsDataObject)chainable;
    }

    @Override
    public Chainable getNext() {
        return this._next;
    }

    @Override
    public void setPrevious(Chainable chainable) {
        this._prev = (TdsDataObject)chainable;
    }

    @Override
    public Chainable getPrevious() {
        return this._prev;
    }

    public abstract void cache() throws IOException;

    public abstract void clear() throws IOException;

    protected void getSize() throws IOException {
        if (this._dataLength != -2) {
            return;
        }
        boolean bl = false;
        if (this._dataFmt._colStatusBytePresent) {
            this._columnStatus = (byte)this.readUnsignedByte();
            if ((this._columnStatus & 1) != 0) {
                this._dataLength = 0;
                this._isNull = true;
                return;
            }
            if (this._columnStatus == 0 || this._columnStatus == 2) {
                bl = true;
            }
        }
        block0 : switch (this._dataFmt._datatype) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 122: 
            case 191: {
                this._dataLength = this._dataFmt._length;
                break;
            }
            case 38: 
            case 47: 
            case 68: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 123: 
            case 147: 
            case 187: 
            case 188: {
                this._dataLength = this.readUnsignedByte();
                break;
            }
            case 37: 
            case 39: 
            case 45: 
            case 103: 
            case 104: {
                this._dataLength = this.readUnsignedByte();
                if (this._dataLength != 0 || !bl) break;
                this._holds0LNN = true;
                break;
            }
            case 34: 
            case 35: 
            case 174: {
                this._textptrlen = this.readUnsignedByte();
                if (this._textptrlen == 0) {
                    this._dataLength = 0;
                    break;
                }
                this._textptr = new byte[this._textptrlen + 8];
                this.in.read(this._textptr, 0, this._textptrlen + 8);
            }
            case 175: 
            case 225: {
                this._dataLength = this.readInt();
                if (this._dataLength != 0 || !bl) break;
                this._holds0LNN = true;
                break;
            }
            case 36: {
                this._dataLength = -1;
                int n2 = this.readUnsignedByte();
                this._classIDLen = this.readShort();
                switch (this._dataFmt._blobType) {
                    case 1: {
                        if (this._classIDLen <= 0) break block0;
                        this._classID = new byte[this._classIDLen];
                        this.read(this._classID, 0, this._classIDLen);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        if (this._classIDLen <= 0) break block0;
                        this.skip(this._classIDLen);
                        break;
                    }
                    default: {
                        this.skip(this._classIDLen);
                        break;
                    }
                }
                break;
            }
            default: {
                ErrorMessage.raiseIOException("JZ0P4");
            }
        }
        if (this._dataLength == 0 && !this._holds0LNN) {
            this._isNull = true;
        }
    }

    protected final long readINTN() throws IOException {
        switch (this._dataLength) {
            case 0: {
                return 0L;
            }
            case 1: {
                return this.readUnsignedByte();
            }
            case 2: {
                return this.readShort();
            }
            case 4: {
                return this.readInt();
            }
            case 8: {
                return this.readLong();
            }
        }
        ErrorMessage.raiseIOException("JZ0P4");
        return 0L;
    }

    protected final long readUINTN() throws IOException {
        switch (this._dataLength) {
            case 1: {
                return this.readUnsignedByte();
            }
            case 2: {
                return this.readUnsignedShortAsInt();
            }
            case 4: {
                return this.readUnsignedIntAsLong();
            }
        }
        ErrorMessage.raiseIOException("JZ0P4");
        return 0L;
    }

    protected final BigDecimal readNUMERIC(int n2, int n3) throws IOException {
        if (this._dataLength == 0) {
            return null;
        }
        byte[] byArray = new byte[this._dataLength];
        this.in.read(byArray);
        return TdsNumeric.numericValue(byArray, n2, n3);
    }

    protected final String readString() throws IOException {
        if (this._isNull) {
            return null;
        }
        if (this._dataLength == 0 && this._holds0LNN) {
            return "";
        }
        int n2 = 0;
        int n3 = 0;
        if (this._context._maxFieldSize != 0) {
            n2 = Math.min(this._dataLength, this._context._maxFieldSize);
            n3 = this._dataLength - n2;
        } else {
            n2 = this._dataLength;
        }
        byte[] byArray = new byte[n2];
        this.in.read(byArray, 0, n2);
        this.in.skip(n3);
        return this._tds._charsetConverter.toUnicode(byArray);
    }

    protected final String readUnicodeString() throws IOException {
        if (this._dataLength == 0 && this._holds0LNN) {
            return "";
        }
        if (this._dataLength == 0) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        if (this._context._maxFieldSize != 0) {
            n2 = Math.min(this._dataLength, this._context._maxFieldSize);
            n3 = this._dataLength - n2;
        } else {
            n2 = this._dataLength;
        }
        byte[] byArray = new byte[n2];
        this.in.read(byArray, 0, n2);
        this.in.skip(n3);
        String string = null;
        String string2 = null;
        string2 = this.getBigEndian() ? "UnicodeBigUnmarked" : "UnicodeLittleUnmarked";
        try {
            string = new String(byArray, 0, n2, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    protected final double readFLTN() throws IOException {
        switch (this._dataLength) {
            case 0: {
                return 0.0;
            }
            case 4: {
                return this.readFloat();
            }
            case 8: {
                return this.readDouble();
            }
        }
        ErrorMessage.raiseIOException("JZ0P4");
        return 0.0;
    }

    protected final BigDecimal readMONEYN() throws IOException {
        switch (this._dataLength) {
            case 0: {
                return null;
            }
            case 4: {
                int n2 = this.readInt();
                return new BigDecimal(BigInteger.valueOf(n2), 4);
            }
            case 8: {
                long l2 = this.readLong();
                return new BigDecimal(BigInteger.valueOf(l2), 4);
            }
        }
        ErrorMessage.raiseIOException("JZ0P4");
        return null;
    }

    protected final TdsDateTime readDATETIMN() throws IOException, SQLException {
        switch (this._dataLength) {
            case 0: {
                return null;
            }
            case 4: {
                int n2 = this.readUnsignedShort();
                int n3 = this.readUnsignedShort();
                return new TdsDateTime(n2, n3, 2);
            }
            case 8: {
                int n4 = this.readInt();
                int n5 = this.readInt();
                return new TdsDateTime(n4, n5, 1);
            }
        }
        ErrorMessage.raiseIOException("JZ0P4");
        return null;
    }

    protected final TdsDateTime readBIGDATETIMN(int n2) throws IOException {
        switch (this._dataLength) {
            case 0: {
                return null;
            }
            case 8: {
                BigDecimal bigDecimal = this.readUnsignedLongAsBigDecimal();
                if (n2 == 187) {
                    n2 = 5;
                } else if (n2 == 188) {
                    n2 = 6;
                }
                return new TdsDateTime(bigDecimal, n2);
            }
        }
        ErrorMessage.raiseIOException("JZ0P4");
        return null;
    }

    protected final TdsDateTime readDATEN() throws IOException, SQLException {
        switch (this._dataLength) {
            case 0: {
                return null;
            }
            case 4: {
                int n2 = this.readInt();
                return new TdsDateTime(n2, 0, 3);
            }
        }
        ErrorMessage.raiseIOException("JZ0P4");
        return null;
    }

    protected final TdsDateTime readTIMEN() throws IOException, SQLException {
        switch (this._dataLength) {
            case 0: {
                return null;
            }
            case 4: {
                int n2 = this.readInt();
                return new TdsDateTime(0, n2, 4);
            }
        }
        ErrorMessage.raiseIOException("JZ0P4");
        return null;
    }

    protected byte[] funkyBinaryReader() throws IOException {
        byte[] byArray = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this._context._maxFieldSize != 0) {
            n2 = Math.min(this._dataLength, this._context._maxFieldSize);
            if (this._dataFmt._datatype == 37 && this._dataFmt._usertype == 3) {
                n3 = Math.min(this._context._maxFieldSize, this._dataFmt._length) - n2;
            }
            n4 = this._dataLength - n2;
        } else {
            n2 = this._dataLength;
            if (this._dataFmt._datatype == 37 && this._dataFmt._usertype == 3) {
                n3 = this._dataFmt._length - n2;
            }
        }
        switch (this._dataFmt._datatype) {
            case 34: 
            case 37: 
            case 45: 
            case 174: 
            case 225: {
                byArray = new byte[n2 + n3];
                this.in.read(byArray, 0, n2);
                for (int i2 = n2; i2 < byArray.length; ++i2) {
                    byArray[i2] = 0;
                }
                if (this._context._maxFieldSize > 0 && this._context._maxFieldSize < this._dataLength) {
                    this.in.read(new byte[n4]);
                    break;
                }
                this.in.skip(n4);
                break;
            }
        }
        return byArray;
    }

    protected void badConversionCombination() throws SQLException {
        try {
            this.startRead();
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        if (this._isNull) {
            return;
        }
        ErrorMessage.raiseError("JZ0TC");
    }

    protected void badConversion(String string) throws SQLException {
        try {
            this.startRead();
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        if (this._isNull) {
            return;
        }
        ErrorMessage.raiseError("JZ009", string);
    }

    protected void noTextPointer() throws SQLException {
        try {
            this.startRead();
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        if (this._isNull) {
            return;
        }
        ErrorMessage.raiseError("JZ0R4");
    }

    public void initialize() {
        this._state = 0;
        this._isNull = false;
        this._dataLength = -2;
    }

    public void startRead() throws IOException {
        switch (this._state) {
            case 0: {
                if (this._prev != null && this._prev._state != 3) {
                    this._prev.cache();
                }
                this._state = 1;
                this.getSize();
            }
        }
    }

    protected abstract void beginRead() throws IOException;

    protected void doRead() throws SQLException {
        try {
            this.beginRead();
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    protected void endRead() throws SQLException {
    }
}

