/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.timedio;

import com.sybase.jdbc4.jdbc.Capture;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.SybProperty;
import com.sybase.jdbc4.timedio.InStreamMgr;
import com.sybase.jdbc4.timedio.RawDbio;
import com.sybase.jdbc4.timedio.SocketDbio;
import com.sybase.jdbc4.timedio.URLDbio;
import com.sybase.jdbc4.utils.BufferInterval;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.sql.SQLException;

public abstract class Dbio {
    public static final int NOT_WAITING = 0;
    public static final int WAITING = 1;
    protected SybProperty _info;
    protected String _host;
    protected int _port;
    protected String _proxyHost = null;
    protected int _proxyPort;
    protected IOException _lastEx;
    protected int _threadState;
    protected InStreamMgr _ioMgr;
    protected BufferInterval _bufIntv;
    protected int _bRead;
    protected InputStream _in;
    protected OutputStream _out;
    protected Capture _cap;

    protected Dbio(String string, int n2, InStreamMgr inStreamMgr, SybProperty sybProperty) throws SQLException {
        this._info = sybProperty;
        this._host = string;
        this._port = n2;
        this._ioMgr = inStreamMgr;
        this._bufIntv = null;
        this._threadState = 0;
        this.checkProxy();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Dbio connect(String string, int n2, InStreamMgr inStreamMgr, SybProperty sybProperty) throws SQLException {
        void var4_8;
        Object var4_4 = null;
        String string2 = sybProperty.getString(17);
        String string3 = sybProperty.getString(31);
        if (string2 != null && string2.indexOf("//") > 0) {
            if (string3 != null) {
                ErrorMessage.raiseError("JZ0US");
            }
            URLDbio uRLDbio = new URLDbio(string, n2, inStreamMgr, sybProperty);
            return var4_8;
        } else if (string3 != null) {
            try {
                SocketDbio socketDbio = new SocketDbio(string, n2, inStreamMgr, sybProperty);
                return var4_8;
            }
            catch (Exception exception) {
                if (!(exception instanceof SQLException) || !((SQLException)exception).getSQLState().equals("JZ0NF")) return var4_8;
                throw (SQLException)exception;
            }
        } else {
            RawDbio rawDbio = new RawDbio(string, n2, inStreamMgr, sybProperty);
        }
        return var4_8;
    }

    public String getSessionID() {
        return null;
    }

    protected void closing() {
    }

    protected abstract void close();

    protected abstract void doConnect(int var1) throws IOException;

    protected boolean startAsync() {
        return false;
    }

    protected void stopAsync() {
    }

    protected void setBufferInfo(BufferInterval bufferInterval, int n2) {
        this._bufIntv = bufferInterval;
        this._bRead = n2;
    }

    protected void doRead(long l2) throws IOException {
        Object object;
        if (this._bufIntv == null) {
            this._ioMgr.setBuffer(l2);
            if (this._bufIntv == null) {
                return;
            }
        }
        int n2 = 0;
        while (true) {
            try {
                n2 = this.reallyRead(l2);
                if (n2 > 0) {
                    break;
                }
            }
            catch (SocketException socketException) {
                if (socketException.getMessage().startsWith("Interrupted system call")) continue;
                if (this._ioMgr._migrating) {
                    throw socketException;
                }
                this._ioMgr.markDead();
            }
            catch (ThreadDeath threadDeath) {
                this._lastEx = ErrorMessage.makeIOException("JZ0TD");
                this._ioMgr.reportError("JZ0T7");
                throw threadDeath;
            }
            catch (InterruptedIOException interruptedIOException) {
                this._lastEx = interruptedIOException;
            }
            catch (IOException iOException) {
                this._ioMgr.markDead();
            }
            if (this._lastEx != null) {
                object = this._lastEx;
                if (this._lastEx instanceof InterruptedIOException) {
                    this._lastEx = null;
                }
                throw object;
            }
            if (n2 != -1) continue;
            if (this._ioMgr._migrating) {
                throw new SocketException();
            }
            this._ioMgr.markDead();
        }
        if ((n2 += this._bRead) > 0) {
            object = this._bufIntv;
            this._bufIntv = null;
            this._ioMgr.moreData((BufferInterval)object, n2);
        } else {
            this._bufIntv = null;
        }
    }

    protected abstract int reallyRead(long var1) throws IOException;

    protected OutputStream getOutputStream() {
        if (this._cap != null) {
            this._out = this._cap.getOutputStream(this._out);
            this._in = this._cap.getInputStream(this._in);
        }
        return this._out;
    }

    protected InputStream getInputStream() {
        return this._in;
    }

    protected Capture getCapture() {
        return this._cap;
    }

    protected void createCapture(SybProperty sybProperty) throws SQLException {
        String string = sybProperty.getString(24);
        if (string != null) {
            try {
                this._cap = new Capture(new FileOutputStream(string));
            }
            catch (IOException iOException) {
                ErrorMessage.raiseWarning("010SP", string, iOException.getMessage());
            }
            catch (SecurityException securityException) {
                ErrorMessage.raiseWarning("010SN", string, securityException.getMessage());
            }
        }
    }

    protected void checkProxy() throws SQLException {
        String string = this._info.getString(17);
        if (string == null) {
            return;
        }
        int n2 = string.indexOf(58);
        if (n2 == -1) {
            ErrorMessage.raiseError("JZ003", string);
        }
        if (string.length() > n2 + 2 && string.charAt(n2 + 1) == '/' && string.charAt(n2 + 2) == '/') {
            this._proxyHost = string;
        } else {
            this._proxyHost = string.substring(0, n2);
            String string2 = string.substring(n2 + 1);
            try {
                this._proxyPort = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMessage.raiseError("JZ0NE", string, numberFormatException.toString());
            }
        }
    }
}

