/*
 * Copyright (C) 2009 ALPHAPROJECT Co.,Ltd. 
 * Copyright (C) 2008 Renesas Solutions Corp.
 * Copyright (C) 2008 Nobuhiro Iwamatsu <iwamatsu.nobuhiro@renesas.com>
 * Copyright (C) 2007 Kenati Technologies, Inc.
 *
 * board/alphaproject/apsh4a2a/apsh4a2a.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <net.h>
#include <asm/io.h>
#include <asm/processor.h>

#define CPU_CMDREG	0xB1000006
#define PDCR        0xffef0006
#define PECR        0xffef0008
#define PFCR        0xffef000a
#define PGCR        0xffef000c
#define PHCR        0xffef000e
#define PICR        0xffef0010
#define PJCR        0xffef0012
#define PKCR        0xffef0014
#define PLCR        0xffef0016
#define PMCR        0xffef0018
#define PNCR        0xffef001a
#define POCR        0xffef001c
#define PSEL1       0xffef0072
#define PSEL2       0xffef0074
#define PSEL3       0xffef0076
#define PSEL4       0xffef0078

int checkboard(void)
{
	puts("BOARD: ALPHAPROJECT AP-SH4A-2A\n");
	return 0;
}

int board_init(void)
{
	vu_short dat;

	/* GPIO Setting (eth1) */
	dat = inw(PSEL1);
	outw((dat & ~0xff00) | 0x2400, PSEL1);
	dat = inw(PSEL2);
	outw((dat & ~0x0fff) | 0x0602, PSEL2);
	dat = inw(PSEL3);
	outw((dat & ~0x7000) | 0x0000, PSEL3);
	dat = inw(PSEL4);
	outw((dat & ~0x074c) | 0x0308, PSEL4);
	outw(0x0000, PFCR);
	outw(0x0000, PGCR);
	outw(0x0000, PHCR);
	outw(0x0000, PICR);
	outw(0x0000, PJCR);
	outw(0x7C15, PLCR);
	outw(0x0000, PNCR);
	outw(inw(POCR) & ~0x000f, POCR);

	icache_enable();

	return 0;
}

int dram_init(void)
{
	DECLARE_GLOBAL_DATA_PTR;

	gd->bd->bi_memstart = CONFIG_SYS_SDRAM_BASE;
	gd->bd->bi_memsize = CONFIG_SYS_SDRAM_SIZE;
	printf("DRAM:  %dMB\n", CONFIG_SYS_SDRAM_SIZE / (1024 * 1024));
	return 0;
}

int board_late_init (void)
{
	ushort buf[3];
	uchar mac[6];
	int i;

	eeprom_read(0, 0, (uchar *)buf, 6);
	for (i = 0; i < 3; i++) {
		mac[i * 2] = buf[i] >> 8;
		mac[i * 2 + 1] = buf[i] & 0xff;
	}
	outl(buf[0] << 16 | buf[1], 0xFEE005C0);
	outl(buf[2], 0xFEE005C8);

	eeprom_read(0, 6, (uchar *)buf, 6);
	outl(buf[0] << 16 | buf[1], 0xFEE00DC0);
	outl(buf[2], 0xFEE00DC8);

#ifdef CONFIG_CMD_USB
#define USBHSC 0xFFEC80F0
	outl(0x00000000, USBHSC);
#endif

	return eth_setenv_enetaddr("ethaddr", mac);
}

static int isprint (unsigned char ch)
{
	if (ch >= 32 && ch < 127)
		return (1);

	return (0);
}

void hexdump (int cnt, unsigned char *data)
{
	int i;
	int run;
	int offset;
	int skip = 0;

	offset = 0;
	while (cnt) {
		if (offset && cnt > 16 && memcmp(data, data - 16, 16) == 0) {
			if (skip++ == 0)
				printf(" ...\n");
			data += 16;
			offset += 16;
			cnt -= 16;
			continue;
		} else {
			skip = 0;
			if (cnt >= 16)
				run = 16;
			else
			run = cnt;
			
			cnt -= run;

			printf ("%04x ", offset);
			for (i = 0; i < 16; i++) {
				if (i == 8)
					printf(" ");
				printf(" ");
				if (i < run)
					printf("%02x", (unsigned int) data[i]);
				else
					printf("  ");
			}
			printf ("  |");
			for (i = 0; i < run; i++)
			printf ("%c", isprint (data[i]) ? data[i] : '.');
			printf ("|\n");
		}

		data = &data[16];
		offset += run;
	}
}
