/*
NSToolbarViewEx.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import "Shiira.h"

struct __tbvFlags {
    unsigned int _layoutInProgress:1;
    unsigned int _sizingToFit:1;
    unsigned int _isEditing:1;
    unsigned int _inCustomizationMode:1;
    unsigned int _sourceDragMoves:1;
    unsigned int _enabledAsDragSrc:1;
    unsigned int _enabledAsDragDest:1;
    unsigned int _actingAsPalette:1;
    unsigned int _usePaletteLabels:1;
    unsigned int _validatesItems:1;
    unsigned int _forceItemsToBeMinSize:1;
    unsigned int _forceAllClicksToBeDrags:1;
    unsigned int _wrapsItems:1;
    unsigned int _useGridAlignment:1;
    unsigned int _autosizesToFitHorizontally:1;
    unsigned int transparentBackground:1;
    unsigned int drawsBaseline:1;
    unsigned int shouldOverrideHalftonePhase:1;
    unsigned int weStartedDrag:1;
    unsigned int dragOptimizationOn:1;
    unsigned int dragIsInsideView:1;
    unsigned int insertionOptimizationShouldEndAfterUpdates:1;
    unsigned int wantsKeyboardLoop:1;
    unsigned int clipIndicatorWasFirstResponder:1;
    unsigned int scheduledDelayedValidateVisibleItems:1;
    unsigned int skippedLayoutWhileDisabled:1;
    unsigned int shouldHideAfterKeyboardHotKeyEvent:1;
    unsigned int RESERVED:5;
};

@interface NSToolbarView : NSView
{
    NSToolbar *_toolbar;
    id _clipIndicator;
    NSClipView *_ivClipView;
    NSMutableDictionary *_toolbarItemViewersByItem;
    NSMutableArray *_orderedItemViewers;
    NSToolbarItemViewer *_dragDataItemViewer;
    int _dragDataItemViewerStartIndex;
    BOOL _dragDataItemShouldBeRemoved;
    NSToolbarItemViewer *_dragDataInsertionGapItemViewer;
    struct _NSPoint _dragDataLastPoint;
    BOOL _insertionAnimationRunning;
    struct _NSPoint _halftonePhaseOverrideValue;
    NSToolbarView *_validDestinationForDragsWeInitiate;
    int _layoutEnabledCount;
    struct __tbvFlags _tbvFlags;
    NSResponder *_windowPriorFirstResponder;
}
@end

@interface NSToolbarViewEx : NSToolbarView
@end
