/*
NSWindowEx.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "NSWindowEx.h"

@implementation NSWindowEx : NSWindow

#pragma mark -
//--------------------------------------------------------------//
// Initialize
//--------------------------------------------------------------//

+ (void)load
{
    [self poseAsClass:[NSWindow class]];
}

#pragma mark -
//--------------------------------------------------------------//
// Actions
//--------------------------------------------------------------//

- (void)closeWindowAction:(id)sender
{
    // Pass to delegate
    id  delegate;
    delegate = [self delegate];
    if (delegate && [delegate respondsToSelector:_cmd]) {
        [delegate performSelector:_cmd withObject:sender];
        return;
    }
    
    // Close window
    [self performClose:self];
}

- (void)closeTabAction:(id)sender
{
    // Pass to delegate
    id  delegate;
    delegate = [self delegate];
    if (delegate && [delegate respondsToSelector:_cmd]) {
        [delegate performSelector:_cmd withObject:sender];
        return;
    }
    
    // Do nothing in NSWindow
}

#pragma mark -
//--------------------------------------------------------------//
// Menu item validation
//--------------------------------------------------------------//

- (BOOL)validateMenuItem:(id<NSMenuItem>)menuItem
{
    // Get tag
    int tag;
    tag = [menuItem tag];
    
    // User defaults
    NSUserDefaults* defaults;
    defaults = [NSUserDefaults standardUserDefaults];
    
    switch (tag) {
    // File menu
    case SRCloseWindowTag: {
        // Prioritize SRMainWindowController
        id  windowController;
        windowController = [self windowController];
        if (windowController && [windowController isKindOfClass:[SRMainWindowController class]]) {
            return [windowController validateMenuItem:menuItem];
        }
        
        [menuItem setKeyEquivalent:@"w"];
        [menuItem setKeyEquivalentModifierMask:NSCommandKeyMask];
        return YES;
    }
    case SRCloseTabTag: {
        // Prioritize SRMainWindowController
        id  windowController;
        windowController = [self windowController];
        if (windowController && [windowController isKindOfClass:[SRMainWindowController class]]) {
            return [windowController validateMenuItem:menuItem];
        }
        
        [menuItem setKeyEquivalent:@""];
        return NO;
    }
    }
    
    return YES;
}

@end
