/*
WebKitEx.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "Shiira.h"

//--------------------------------------------------------------//
// Hacked Web Kit APIs
//--------------------------------------------------------------//

@interface NSURL (WebNSURLExtras)
+ (id)_web_URLWithUserTypedString:(id)fp8;
- (id)_web_userVisibleString;
- (id)_web_hostString;
@end

@interface WebFrame (WebPrivate)
- (id)_bridge;
- (void)_setShouldCreateRenderers:(BOOL)flag;
- (BOOL)_shouldCreateRenderers;
@end

@interface WebHTMLView : NSView <WebDocumentView, WebDocumentSearching, WebDocumentText>
{
    id  _private;
}
@end

@interface WebClipView : NSClipView
{
    BOOL _haveAdditionalClip;
    struct _NSRect _additionalClip;
}
@end

@interface WebSearchableTextView : NSTextView <WebDocumentSearching>
{
}
@end

@interface WebTextView : WebSearchableTextView <WebDocumentView, WebDocumentText>
{
    float   _textSizeMultiplier;
}
@end

@interface WebIconDatabase : NSObject
{
    id _private;
}
+ (id)sharedIconDatabase;
- (id)iconForURL:(NSString*)urlString withSize:(NSSize)size cache:(BOOL)flag;
- (id)defaultIconWithSize:(NSSize)size;
@end

@interface WebCoreStatistics : NSObject
{
}

+ (id)statistics;
+ (void)emptyCache;
+ (void)setCacheDisabled:(BOOL)fp8;
+ (int)javaScriptObjectsCount;
+ (int)javaScriptInterpretersCount;
+ (int)javaScriptNoGCAllowedObjectsCount;
+ (int)javaScriptReferencedObjectsCount;
+ (id)javaScriptRootObjectClasses;
+ (void)garbageCollectJavaScriptObjects;
+ (BOOL)shouldPrintExceptions;
+ (void)setShouldPrintExceptions:(BOOL)fp8;
@end

@interface WebKitStatistics : NSObject
{
}

+ (int)webViewCount;
+ (int)frameCount;
+ (int)dataSourceCount;
+ (int)viewCount;
+ (int)bridgeCount;
+ (int)HTMLRepresentationCount;

@end

@interface WebCoreTextRendererFactory : NSObject
{
}
@end

#if 0
@interface WebTextRendererFactory : WebCoreTextRendererFactory
{
    NSMutableDictionary *cacheForScreen;
    NSMutableDictionary *cacheForPrinter;
    NSMutableDictionary *viewBuffers;
    NSMutableArray *viewStack;
}

+ (void)createSharedFactory;
+ (id)sharedFactory;
- (BOOL)coalesceTextDrawing;
- (void)startCoalesceTextDrawing;
- (void)endCoalesceTextDrawing;
- (id)glyphBufferForFont:(id)fp8 andColor:(id)fp12;
- (void)clearCaches;
- (BOOL)isFontFixedPitch:(id)fp8;
- (id)init;
- (void)dealloc;
- (id)rendererWithFont:(id)fp8 usingPrinterFont:(BOOL)fp12;
- (id)fallbackFontWithTraits:(unsigned int)fp8 size:(float)fp12;
- (id)fontWithFamilies:(id *)fp8 traits:(unsigned int)fp12 size:(float)fp16;
- (id)fontWithFamily:(id)fp8 traits:(unsigned int)fp12 size:(float)fp16;
- (id)cachedFontFromFamily:(id)fp8 traits:(unsigned int)fp12 size:(float)fp16;

@end
#endif

@interface WebURLsWithTitles : NSObject
{
}

+ (id)arrayWithIFURLsWithTitlesPboardType;
+ (void)writeURLs:(id)fp8 andTitles:(id)fp12 toPasteboard:(id)fp16;
+ (id)titlesFromPasteboard:(id)fp8;
+ (id)URLsFromPasteboard:(id)fp8;
@end

@interface WebURLsWithTitles (NSURLExtras)
+ (id)_web_userVisibleURLStringsFromPasteboard:(id)fp8;
@end

@interface WebView (WebPrivate)
- (void)_close;
@end

@protocol WebCoreBridge
- (void)setDefersLoading:(BOOL)fp8;
@end

//--------------------------------------------------------------//
// Extended Web Kit APIs
//--------------------------------------------------------------//

@interface WebViewEx : WebView
{
}
@end

@interface WebView (DocumentText)
- (NSString*)selectedString;
@end

@interface WebHTMLViewEx : WebHTMLView
{
}
@end

#if 0
@interface WebClipViewEx : WebClipView
{
}
@end
#endif

extern NSString*    SRWebImageSizeChangeNotification;

@interface WebImageViewEx_pseudo : NSView
{
}

- (BOOL)autoResizeMode;
- (void)setAutoResizeMode:(BOOL)flag;
@end

@interface WebFrame (FindFrame)
- (WebFrame*)srFindFrameNamed:(NSString*)frameName;
@end

@interface WebIconDatabase (IconURL)
- (NSString*)iconURLOfURL:(NSString*)URLString;
@end
