/*
SRHalfTransparentButton.m

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRHalfTransparentButton.h"

@implementation SRHalfTransparentButton

#pragma mark -
//--------------------------------------------------------------//
// Initialize
//--------------------------------------------------------------//

- (void)_setTrackingRect
{
    // Remove old one
    if (_trackingRectTag) {
        [self removeTrackingRect:_trackingRectTag];
    }
    
    _trackingRectTag = [self addTrackingRect:[self bounds] 
            owner:self 
            userData:NULL 
            assumeInside:NO];
    _trackingRect = [self frame];
}

- (id)initWithFrame:(NSRect)frame
{
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    // Configure itself
    [self setBordered:NO];
    [self setButtonType:NSMomentaryChangeButton];
    
    // Set tracking rect
    [self _setTrackingRect];
    
    return self;
}

- (void)awakeFromNib
{
    // Set tracking rect
    [self _setTrackingRect];
}

- (void)dealloc
{
    // Remove tracking rect
    [self removeTrackingRect:_trackingRectTag];
    
    [_trImage release];
    [_altTrImage release];
    
    [super dealloc];
}

#pragma mark -
//--------------------------------------------------------------//
// Half transparent
//--------------------------------------------------------------//

- (BOOL)halfTransparent
{
    return _halfTransparent;
}

- (void)setHalfTransparent:(BOOL)flag
{
    if (_halfTransparent != flag) {
        _halfTransparent = flag;
        
        [self setNeedsDisplay:YES];
    }
}

#pragma mark -
//--------------------------------------------------------------//
// Images
//--------------------------------------------------------------//

- (NSImage*)rolloverImage
{
    return _rolloverImage;
}

- (void)setRolloverImage:(NSImage*)image
{
    [_rolloverImage release];
    _rolloverImage = [image retain];
}

- (NSImage*)halfTransparentImage
{
    return _trImage;
}

- (void)setHalfTransparentImage:(NSImage*)image
{
    [_trImage release];
    _trImage = [image retain];
}

- (NSImage*)alternateHalfTransparentImage
{
    return _altTrImage;
}

- (void)setAlternateHalfTransparentImage:(NSImage*)image
{
    [_altTrImage release];
    _altTrImage = [image retain];
}

#pragma mark -
//--------------------------------------------------------------//
// Mouse moving
//--------------------------------------------------------------//

- (void)mouseEntered:(NSEvent*)event
{
    // Swap to rollover image
    if (_rolloverImage) {
        _regularImage = [[self image] retain];
        [self setImage:_rolloverImage];
    }
}

- (void)mouseExited:(NSEvent*)event
{
    // Swap to regular image
    if (_regularImage) {
        [self setImage:_regularImage];
        [_regularImage release];
    }
}

- (void)setFrame:(NSRect)frame
{
    [super setFrame:frame];
    
    // Update tracking rect
    if (!NSEqualRects(_trackingRect, [self frame])) {
        [self _setTrackingRect];
    }
}

- (void)setFrameOrigin:(NSPoint)origin
{
    [super setFrameOrigin:origin];
    
    // Update tracking rect
    if (!NSEqualRects(_trackingRect, [self frame])) {
        [self _setTrackingRect];
    }
}

@end
