#import "SRImageComboBox.h"
#import "SRImageComboBoxCell.h"

@implementation SRImageComboBox

+ (Class)cellClass
{
    // Use SRImageComboBoxCell class
    return [SRImageComboBoxCell class];
}

- (void)setImage:(NSImage*)image
{
    // Set image to cell
    [[self cell] setImage:image];
}

- (NSImage*)image
{
    // Get image from cell
    return [[self cell] image];
}

- (void)mouseDown:(NSEvent *)theEvent
{
    [[self cell] imageTrackMouse:theEvent inRect:[self bounds] ofView:self untilMouseUp:YES];
    [super mouseDown:theEvent];
}

@end
