#import "NSCellEx.h"
#import "SRImageComboBoxCell.h"

@implementation SRImageComboBoxCell

- (void)dealloc
{
    [_image release];
    _image = nil;
    [super dealloc];
}

- (id)copyWithZone:(NSZone*)zone
{
    SRImageComboBoxCell*    cell;
    cell = (SRImageComboBoxCell *)[super copyWithZone:zone];
    cell->_image = [_image retain];
    return cell;
}

- (void)setImage:(NSImage*)image {
    if (_image != image) {
        [_image release];
        _image = [image retain];
    }
}

- (NSImage *)image {
    return _image;
}

- (NSRect)imageFrameForCellFrame:(NSRect)cellFrame
{
    if (_image) {
        NSRect imageFrame;
        imageFrame.size = [_image size];
        imageFrame.origin = cellFrame.origin;
        imageFrame.origin.x += 3;
        imageFrame.origin.y += ceil((cellFrame.size.height - imageFrame.size.height) / 2);
        return imageFrame;
    }
    else {
        return NSZeroRect;
    }
}

- (void)selectWithFrame:(NSRect)rect 
        inView:(NSView*)controlView 
        editor:(NSText*)textObj 
        delegate:(id)object 
        start:(int)selStart 
        length:(int)selLength
{
    NSRect  textFrame;
    NSRect  imageFrame;
    NSDivideRect(rect, &imageFrame, &textFrame, 3 + [_image size].width, NSMinXEdge);
    [super selectWithFrame:textFrame 
            inView:controlView 
            editor:textObj 
            delegate:object 
            start:selStart 
            length:selLength];
}

- (void)editWithFrame:(NSRect)rect 
        inView:(NSView*)controlView 
        editor:(NSText*)textObj 
        delegate:(id)object 
        event:(NSEvent*)event 
{
    NSRect  textFrame;
    NSRect  imageFrame;
    NSDivideRect(rect, &imageFrame, &textFrame, 3 + [_image size].width, NSMinXEdge);
    [super editWithFrame:textFrame 
            inView:controlView 
            editor:textObj 
            delegate:object 
            event:event];
}

- (void)drawInteriorWithFrame:(NSRect)cellFrame 
        inView:(NSView *)controlView
{
    if (_image != nil) {
        NSSize	imageSize;
        NSRect	imageFrame;
        
        imageSize = [_image size];
        NSDivideRect(cellFrame, &imageFrame, &cellFrame, 3 + imageSize.width, NSMinXEdge);
        imageFrame.origin.x += 3;
        imageFrame.size = imageSize;
        imageFrame.origin.y += ceil((cellFrame.size.height - imageFrame.size.height) / 2);
        if ([self drawsBackground]) {
            [[self backgroundColor] set];
            NSRectFill(imageFrame);
        }
        
        imageFrame.origin.y = cellFrame.origin.y;
        if ([controlView isFlipped]) {
            imageFrame.origin.y += ceil((cellFrame.size.height + imageFrame.size.height) / 2);
        }
        else {
            imageFrame.origin.y += ceil((cellFrame.size.height - imageFrame.size.height) / 2);
        }
        
        [_image compositeToPoint:imageFrame.origin operation:NSCompositeSourceOver];
    }
    [super drawInteriorWithFrame:cellFrame inView:controlView];
}

- (NSSize)cellSize
{
    NSSize cellSize = [super cellSize];
    cellSize.width += (_image ? [_image size].width : 0) + 3;
    return cellSize;
}

- (void)_drawFocusRingWithFrame:(NSRect)rect
{
    if (_image) {
        rect.origin.x -= [_image size].width + 3;
        rect.size.width += [_image size].width + 3;
    }
    [super _drawFocusRingWithFrame:rect];
}

- (BOOL)imageTrackMouse:(NSEvent*)event 
        inRect:(NSRect)cellFrame 
        ofView:(NSView*)controlView 
        untilMouseUp:(BOOL)untilMouseUp
{
    // Check mouse is in image or not
    NSRect  imageFrame;
    NSPoint point;
    imageFrame = [self imageFrameForCellFrame:cellFrame];
    point = [controlView convertPoint:[event locationInWindow] fromView:nil];
NSLog(@"imageFrame %@", NSStringFromRect(imageFrame));
NSLog(@"point %@", NSStringFromPoint(point));
    
    if (NSPointInRect(point, imageFrame)) {
NSLog(@"Start dragging");
        //
        // Start dragging
        //
        
        // Get sring and its size
        NSAttributedString* attrString;
        NSSize              stringSize;
        attrString = [self attributedStringValue];
        stringSize = [attrString size];
        
        // Create image
        NSSize      imageSize;
        NSImage*    dragImage;
        imageSize = stringSize;
        imageSize.width += [_image size].width + 3;
        dragImage = [[NSImage alloc] initWithSize:imageSize];
        [dragImage autorelease];
        
        // Draw image
        NSMutableAttributedString*  coloredAttrString;
        float                       alpha = 0.7;
        
        coloredAttrString = [[NSMutableAttributedString alloc] 
                initWithAttributedString:attrString];
        [coloredAttrString autorelease];
        [coloredAttrString addAttribute:NSForegroundColorAttributeName 
                value:[NSColor colorWithCalibratedWhite:0.0 alpha:alpha] 
                range:NSMakeRange(0, [attrString length])];
        
        [NSGraphicsContext saveGraphicsState];
        [dragImage lockFocus];
        [_image dissolveToPoint:NSZeroPoint fraction:alpha];
        [coloredAttrString drawAtPoint:NSMakePoint([_image size].width + 3, 0)];
        [dragImage unlockFocus];
        [NSGraphicsContext restoreGraphicsState];
        
        // Create paste board
        NSPasteboard*   pboard;
        pboard = [NSPasteboard pasteboardWithName:NSDragPboard];
        [pboard declareTypes:[NSArray arrayWithObjects:NSStringPboardType, nil] owner:self];
        [pboard setString:[self stringValue] forType:NSStringPboardType];
        
        // Start dragging
        NSPoint startAt;
        startAt = imageFrame.origin;
        if ([controlView isFlipped]) {
            startAt.y = cellFrame.size.height - startAt.y;
        }
        
        [controlView dragImage:dragImage 
                at:startAt 
                offset:NSZeroSize 
                event:event 
                pasteboard:pboard 
                source:self 
                slideBack:YES];
    }
    
#if 0
    return [super trackMouse:event 
        inRect:cellFrame 
        ofView:controlView 
        untilMouseUp:untilMouseUp];
#endif
}

- (void)resetCursorRect:(NSRect)cellFrame 
        inView:(NSView*)controlView
{
    NSRect  textFrame;
    NSRect  imageFrame;
    NSDivideRect(cellFrame, &imageFrame, &textFrame, 3 + [_image size].width, NSMinXEdge);
    [super resetCursorRect:textFrame inView:controlView];
}

@end
