/*
SRContextMenu.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "SRError.h"

// Bookmark context menu
enum {
    SROpenBookmarkTag= 4000, 
    SROpenBookmarkInNewWindowTag= 4001, 
    SROpenBookmarkInNewTabTag= 4002, 
    SROpenBookmarkInTabsTag= 4003, 
    SROpenBookmarkInNewBackgroundWindowTag= 4004, 
    SROpenBookmarkInNewBackgroundTabTag= 4005, 
    
    SRDeleteBookmarkTag = 4010, 
    
    SRCreateNewBookmarkFolderTag = 4020, 
};

// WebView context menu
enum {
    SRViewSourceTag = 4100, 
    SRFindBySearchEngineTag = 4101, 
    SRFindByOtherSearchEngineTag = 4102, 
    
    SROpenLinkInNewTabTag = 4110, 
    SRAddLinkToBokkmarksTag = 4111, 
    SROpenLinkInNewBackgroundWindowTag = 4112, 
    SROpenLinkInNewBackgroundTabTag = 4113, 
    SROpenAllLinksInNewTabsTag = 4114, 
    SROpenAllLinksInNewBackgroundTabsTag = 4115, 
    
    SROpenImageInNewTabTag = 4120, 
    SRCopyImageURLTag = 4121, 
    SROpenImageInNewBackgroundWindowTag = 4122, 
    SROpenImageInNewBackgroundTabTag = 4123, 
    
    SRWebViewGoBackTag = 4130, 
    SRWebViewGoForwardTag = 4131, 
    SRWebViewReloadPageTag = 4132, 
    SRWebViewStopLoadingTag = 4133, 
};

// Tab context menu
enum {
    SRTabNewTabTag = 4200, 
    SRTabCloseTabTag = 4201, 
    SRTabShowAllTabsTag = 4202, 
    
    SRTabCloseAllRightTag = 4210, 
    SRTabCloseAllLeftTag = 4211, 
    SRTabCloseAllOtherTag = 4212, 
    
    SRTabBookmarkAllTabTag = 4220, 
    SRTabAccordingToStringTag = 4221, 
    SRTabReloadTabTag = 4222, 
    SRTabReloadAllTabsTag = 4223, 

    SRTabChangeTabStyleTag = 4230, 
};

// History context menu
enum {
    SROpenHistoryTag = 4300, 
    SROpenHistoryInNewWindowTag = 4301, 
    SROpenHistoryInNewTabTag = 4302, 
    SROpenHistoryInTabsTag = 4303, 
    SROpenHisotryInNewBackgroundWindowTag = 4304, 
    SROpenHistoryInNewBackgroundTabTag = 4305, 
    
    SRDeleteHistoryTag = 4310, 
    
    SRBookmarkHistoryTag = 4320, 
    SRBookmarkHistoryAllTag = 4321, 
};

// Download context menu
enum {
    SRDownloadItemTag= 4400, 
    SRDownloadItemsAllTag= 4401, 
    SROpenReferenceURLTag = 4402, 
    
    SRDeleteDownloadHistoryTag = 4410, 
};

// RSS context menu
enum {
    SROpenRSSTag= 4500, 
    SROpenRSSInNewWindowTag = 4501, 
    SROpenRSSInNewTabTag = 4502, 
    SROpenRSSInTabsTag = 4503, 
    SROpenRSSInNewBackgroundWindowTag = 4504, 
    SROpenRSSInNewBackgroundTabTag = 4505, 
    SROpenRSSWebSiteTag = 4506, 
    
    SRDeleteRSSTag = 4510, 
    SRMarkAsReadTag = 4511, 
    SRMarkAsUnreadTag = 4512, 
    SRMarkAllArticlesAsReadTag = 4513, 
    SRDeleteAllRSSTag = 4514, 
    
    SRViewSourceRSSTag = 4520, 
    
    SRFlatSytleTag = 4530, 
    SRWebSiteStyleTag = 4531, 
    
    SRReloadRSSAction = 4540, 
    SRRevealInBookmarkAction = 4541, 
    SRNotUpdateAutioAction = 4542, 
};

@interface SRContextMenu : NSObject
{
    IBOutlet id _webViewContextMenu;
    IBOutlet id _bookmarkContextMenu;
    IBOutlet id _historyContextMenu;
    IBOutlet id _downloadContextMenu;
    IBOutlet id _tabContextMenu;
    IBOutlet id _RSSContextMenu;
}

// Accessing context menu
+ (NSMenu*)webViewContextMenu;
+ (NSMenu*)bookmarkContextMenu;
+ (NSMenu*)historyContextMenu;
+ (NSMenu*)downloadContextMenu;
+ (NSMenu*)tabContextMenu;
+ (NSMenu*)RSSContextMenu;

// Copying menu
+ (NSMenu*)copyMenuFrom:(NSMenu*)menu ofTags:(NSArray*)tags target:(id)target;
+ (NSMenuItem*)copyMenuItemFrom:(NSMenu*)menu ofTag:(int)tag target:(id)target;

// Insert menu item
+ (void)insertMenuItem:(NSMenuItem*)menuItem inItems:(NSMutableArray*)itmes afterTag:(int)tag;
+ (void)removeMenuItem:(NSMenuItem*)menuItem fromItems:(NSMutableArray*)itmes ofTag:(int)tag;

@end
