/*
SRDDArrayController.m

Author: Hetima

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/


#import "SRDDArrayController.h"
//#import <objc/objc-runtime.h>



@implementation SRDDArrayController

- (void)dealloc {
	[_pasteboardType release];
    [super dealloc];
}

- (void)awakeFromNib
{
    // Create unique string
    CFUUIDRef   uuid=CFUUIDCreate(NULL);
    NSString*   typeStr=(NSString*)CFUUIDCreateString(NULL, uuid);
    [typeStr autorelease];
	if([typeStr length]>0){
		[self setPasteboardType:[typeStr stringByAppendingString:@"_pbType"]];
	}
    
    CFRelease(uuid);
}

/*
-(id)delegate
{
	return delegate;
}
*/

-(void)setPasteboardType:(NSString*)typeStr
{
	[self setUpDragDropForTableView:oTableView pasteboardType:typeStr];
}

-(NSTableView*)tableView
{
	return oTableView;
}

/*
- (void)add:(id)sender
{
    id  newObject=nil;
    
    if([delegate respondsToSelector:@selector(defaultObjecOfSRDDArrayController:)]){
        newObject=objc_msgSend(delegate, @selector(defaultObjecOfSRDDArrayController:), self);
        //[delegate defaultObjecOfSRDDArrayController:self];
    }
    if(newObject){
        [super addObject:newObject];
    }else{
        [super add:sender];
    }
}
*/

-(NSString*)pasteboardType
{
	return _pasteboardType;
}

-(void)setUpDragDropForTableView:(NSTableView*)table pasteboardType:(NSString*)type
{
	if(type != _pasteboardType){
		[_pasteboardType autorelease];
		_pasteboardType=[type retain];
        [table unregisterDraggedTypes];
        if(_pasteboardType){
            [table registerForDraggedTypes:[NSArray arrayWithObjects:_pasteboardType, nil]];
        }
	}
}


//drag & drop
- (BOOL)tableView:(NSTableView *)tableView writeRows:(NSArray*)rows toPasteboard:(NSPasteboard*)pboard
{
    if(tableView != oTableView || _pasteboardType==nil || [rows count]>1)  return NO;

    [pboard declareTypes:[NSArray arrayWithObjects: _pasteboardType, nil ]owner:nil];
    [pboard setString:[NSString stringWithFormat:@"%@",[rows objectAtIndex:0]] forType:_pasteboardType];

    return YES;
}

- (NSDragOperation)tableView:(NSTableView*)tableView 
    validateDrop:(id <NSDraggingInfo>)info 
    proposedRow:(int)row 
    proposedDropOperation:(NSTableViewDropOperation)operation
{
    if(tableView != oTableView || _pasteboardType==nil)    return NSDragOperationNone;

    NSPasteboard    *pb=[info draggingPasteboard];
    int draggedRow=[[pb stringForType:_pasteboardType]intValue];

    if(operation == NSTableViewDropOn || row == draggedRow || row == draggedRow + 1){
        return NSDragOperationNone;
    }
    
    return NSDragOperationMove;
}

- (BOOL)tableView:(NSTableView*)tableView 
    acceptDrop:(id <NSDraggingInfo>)info 
    row:(int)row 
    dropOperation:(NSTableViewDropOperation)operation
{
    if(tableView != oTableView || _pasteboardType==nil)    return NO;

    NSPasteboard *pb=[info draggingPasteboard];
    int draggedRow=[[pb stringForType:_pasteboardType]intValue];
    
    [[self content]insertObject:[[self content] objectAtIndex:draggedRow]atIndex: row];

    if(row < draggedRow){
        [[self content]removeObjectAtIndex:draggedRow+1];
    }else{
        [[self content]removeObjectAtIndex:draggedRow];
    }

    [tableView reloadData];

    if(row < draggedRow){
        [tableView selectRow: row byExtendingSelection:NO];
    }else{
        [tableView selectRow: row-1 byExtendingSelection:NO];
    }
    
    return YES;
}


@end
