/*
WebKitEx.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "SRError.h"

//--------------------------------------------------------------//
// Hacked Web Kit APIs
//--------------------------------------------------------------//

@interface NSURL (WebNSURLExtras)
+ (id)_web_URLWithUserTypedString:(id)fp8;
- (id)_web_userVisibleString;
- (id)_web_hostString;
@end

@interface WebFrame (WebPrivate)
- (id)_bridge;
- (void)_setShouldCreateRenderers:(BOOL)flag;
- (BOOL)_shouldCreateRenderers;
@end

@protocol WebDocumentDragging <NSObject>
@end
@protocol WebDocumentElement <NSObject>
@end
@protocol WebDocumentSelection <NSObject>
@end

@interface WebHTMLView : NSView <WebDocumentView, WebDocumentSearching, WebDocumentText, WebDocumentDragging, WebDocumentElement, WebDocumentSelection>
{
    id  _private;
}
- (void)_resetCachedWebPreferences:(NSNotification*)ignored;
@end

@interface WebSearchableTextView : NSTextView <WebDocumentSearching>
{
}
@end

@interface WebTextView : WebSearchableTextView <WebDocumentView, WebDocumentText>
{
    float   _textSizeMultiplier;
}
@end

extern NSString*    WebIconDatabaseDidAddIconNotification;

@interface WebIconDatabase : NSObject
{
    id _private;
}
+ (WebIconDatabase*)sharedIconDatabase;
- (NSImage*)iconForURL:(NSString*)URL withSize:(NSSize)size;
- (NSImage*)iconForURL:(NSString*)urlString withSize:(NSSize)size cache:(BOOL)flag;
- (NSString*)iconURLForURL:(NSString*)URL;
- (NSImage*)defaultIconWithSize:(NSSize)size;
- (void)retainIconForURL:(NSString*)URL;
- (void)releaseIconForURL:(NSString*)URL;
- (void)delayDatabaseCleanup;
- (void)allowDatabaseCleanup;
@end

@interface WebIconDatabase (WebPrivate)
- (BOOL)_isEnabled;
- (void)_setIcon:(NSImage*)icon forIconURL:(NSString*)iconURL;
- (void)_setHaveNoIconForIconURL:(NSString*)iconURL;
- (void)_setIconURL:(NSString*)iconURL forURL:(NSString*)URL;
- (BOOL)_hasIconForIconURL:(NSString*)iconURL;
@end

@interface WebCoreStatistics : NSObject
{
}

+ (id)statistics;
+ (void)emptyCache;
+ (void)setCacheDisabled:(BOOL)fp8;
+ (int)javaScriptObjectsCount;
+ (int)javaScriptInterpretersCount;
+ (int)javaScriptNoGCAllowedObjectsCount;
+ (int)javaScriptReferencedObjectsCount;
+ (id)javaScriptRootObjectClasses;
+ (void)garbageCollectJavaScriptObjects;
+ (BOOL)shouldPrintExceptions;
+ (void)setShouldPrintExceptions:(BOOL)fp8;
@end

@interface WebKitStatistics : NSObject
{
}

+ (int)webViewCount;
+ (int)frameCount;
+ (int)dataSourceCount;
+ (int)viewCount;
+ (int)bridgeCount;
+ (int)HTMLRepresentationCount;

@end

@interface WebURLsWithTitles : NSObject
{
}

+ (id)arrayWithIFURLsWithTitlesPboardType;
+ (void)writeURLs:(id)fp8 andTitles:(id)fp12 toPasteboard:(id)fp16;
+ (id)titlesFromPasteboard:(id)fp8;
+ (id)URLsFromPasteboard:(id)fp8;
@end

@interface WebURLsWithTitles (NSURLExtras)
+ (id)_web_userVisibleURLStringsFromPasteboard:(NSPasteboard*)fp8;
@end

@interface WebView (WebPrivate)
- (void)_close;

- (BOOL)canMakeTextStandardSize;
- (IBAction)makeTextStandardSize:(id)sender;
@end

@protocol WebCoreBridge
- (void)setDefersLoading:(BOOL)fp8;
@end

@interface WebPreferences (WebPreferencesKVCSupport)
- (BOOL)isPlugInsEnabled;
@end

@interface WebPreferences (Printing)
- (BOOL)shouldPrintBackgrounds;
- (void)setShouldPrintBackgrounds:(BOOL)flag;
@end

@interface WebViewEx : WebView
{
}
@end

@interface WebView (DocumentText)
- (NSString*)selectedString;
@end

@interface WebHTMLViewEx : WebHTMLView
{
}
@end

extern NSString*    SRWebImageSizeChangeNotification;

@interface WebImageViewEx_pseudo : NSView
{
}

- (BOOL)autoResizeMode;
- (void)setAutoResizeMode:(BOOL)flag;
@end

typedef enum {
    WebFrameLoadTypeStandard,
    WebFrameLoadTypeBack,
    WebFrameLoadTypeForward,
    WebFrameLoadTypeIndexedBackForward,		// a multi-item hop in the backforward list
    WebFrameLoadTypeReload,
    WebFrameLoadTypeReloadAllowingStaleData,
    WebFrameLoadTypeSame,		// user loads same URL again (but not reload button)
    WebFrameLoadTypeInternal
} WebFrameLoadType;

typedef enum {
    WebFrameStateProvisional,
    
    // This state indicates we are ready to commit to a page,
    // which means the view will transition to use the new data source.
    WebFrameStateCommittedPage,

    // This state indicates that it is reasonable to perform a layout.
    WebFrameStateLayoutAcceptable,

    WebFrameStateComplete
} WebFrameState;

@interface WebFrameEx : WebFrame
{
}
@end

@interface WebFrame (FindFrame)
- (WebFrame*)srFindFrameNamed:(NSString*)frameName;
@end

@interface WebFrame (Private)
- (void)_transitionToCommitted:(NSDictionary*)pageCache;
- (void)_goToItem:(WebHistoryItem*)item withLoadType:(WebFrameLoadType)type;
- (void)_transitionToLayoutAcceptable;
- (WebFrameState)_state;
- (WebFrameLoadType)_loadType;
@end

@protocol WebCoreImageRenderer <NSObject, NSCopying>
- (BOOL)incrementalLoadWithBytes:(const void *)fp8 length:(unsigned int)fp12 complete:(BOOL)fp16 callback:(id)fp20;
- (struct _NSSize)size;
- (void)resize:(struct _NSSize)fp8;
- (void)drawImageInRect:(struct _NSRect)fp8 fromRect:(struct _NSRect)fp24;
- (void)drawImageInRect:(struct _NSRect)fp8 fromRect:(struct _NSRect)fp24 compositeOperator:(int)fp40 context:(struct CGContext *)fp44;
- (void)stopAnimation;
- (void)tileInRect:(struct _NSRect)fp8 fromPoint:(struct _NSPoint)fp24 context:(struct CGContext *)fp32;
- (BOOL)isNull;
- (id)retainOrCopyIfNeeded;
- (void)increaseUseCount;
- (void)decreaseUseCount;
- (void)flushRasterCache;
- (struct CGImage *)imageRef;
- (void)resetAnimation;
@end

@interface WebImageRenderer : NSObject <WebCoreImageRenderer>
{
    NSString *MIMEType;
    id imageData;
    NSImage *nsimage;
    NSData *TIFFData;
    struct _NSRect targetAnimationRect;
    struct _NSSize adjustedSize;
    BOOL isSizeAdjusted;
}

- (void)resize:(struct _NSSize)fp8;
- (struct _NSSize)size;
- (id)image;
@end

@interface WebImageData : NSObject <NSCopying>
{
    unsigned int imagesSize;
    struct CGImage **images;
    unsigned int imagePropertiesSize;
    struct __CFDictionary *fileProperties;
    struct __CFDictionary **imageProperties;
    struct CGImageSource *imageSource;
    struct CGSize size;
    BOOL haveSize;
    struct __CFDictionary *animatingRenderers;
    NSTimer *frameTimer;
    unsigned int frameDurationsSize;
    float *frameDurations;
    unsigned int currentFrame;
    int repetitionsComplete;
    BOOL animationFinished;
    NSLock *decodeLock;
    id _PDFDoc;
    BOOL isPDF;
    BOOL isSolidColor;
    struct CGColor *solidColor;
    BOOL sizeAvailable;
}

- (struct CGSize)size;

@end

@interface WebImageRepresentation : NSObject <WebDocumentRepresentation>
{
    WebDataSource *dataSource;
    WebImageRenderer *image;
    BOOL doneLoading;
}

- (void)dealloc;
- (id)image;
- (id)URL;
- (BOOL)doneLoading;
- (void)setDataSource:(id)fp8;
- (void)receivedData:(id)fp8 withDataSource:(id)fp12;
- (void)receivedError:(id)fp8 withDataSource:(id)fp12;
- (void)finishedLoadingWithDataSource:(id)fp8;
- (BOOL)canProvideDocumentSource;
- (id)documentSource;
- (id)title;
- (id)data;
- (id)filename;
- (id)archive;

@end

@interface DOMNode (SRExtension)
- (DOMNode*)firstChildOfType:(unsigned int)type;
- (DOMNode*)firstChildOfNodeName:(NSString*)nodeName;
- (DOMNode*)firstChildOfClass:(Class)nodeClass;

- (BOOL)isDescendant:(DOMNode*)node;

@end

@interface WebBasePluginPackage_pseudo : NSObject
@end
