/*
SRSDAppController.m

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRSDSyndication.h"
#import "SRSDAppController.h"
#import "SRSDFeedManager.h"
#import "SRSDXMLFileManager.h"

#import "NSDateEx.h"

@implementation SRSDAppController

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (void)_setFactoryDefaults
{
    NSUserDefaults* defaults;
    defaults = [NSUserDefaults standardUserDefaults];
    
    // Load FactoryDefaults.plist
    NSString*               path;
    NSMutableDictionary*    dict;
    path = [[NSBundle mainBundle] pathForResource:@"RSSFactoryDefaults" ofType:@"plist"];
    if (path) {
        dict = [NSMutableDictionary dictionaryWithContentsOfFile:path];
    }
    else {
        dict = [NSMutableDictionary dictionary];
    }
    
    // Register factory defaults
    [defaults registerDefaults:dict];
}

- (id)init
{
    self = [super init];
    if (!self) {
        return nil;
    }
    
    // Add date formats
    NSString*   path;
    path = [[NSBundle mainBundle] pathForResource:@"DateFormats" ofType:@"plist"];
    if (path) {
        [NSDate addDateFromatsWithContentsOfFile:path];
    }
    
    // Load SRXML
	NSBundle*	mainBundle;
	NSBundle*	xmlBundle;
	mainBundle = [NSBundle mainBundle];
	path = [mainBundle privateFrameworksPath];
    // For Tiger
    if (NSClassFromString(@"NSXMLDocument")) {
        path = [path stringByAppendingPathComponent:@"SRXMLTiger.framework"];
//        path = [path stringByAppendingPathComponent:@"SRXMLPanther.framework"];
    }
    // For Panther
    else {
        path = [path stringByAppendingPathComponent:@"SRXMLPanther.framework"];
    }
	xmlBundle = [NSBundle bundleWithPath:path];
	if (!xmlBundle) {
		NSLog(@"Can't make bundle at path %@", path);
	}
	else {
		if (![xmlBundle load]) {
			NSLog(@"Can't load SRXML bundle");
		}
	}
    
    // Register distributed notifications
    [[NSDistributedNotificationCenter defaultCenter] addObserver:self 
            selector:@selector(sdFeedRequestedCancelRefresh:) 
            name:SRSDFeedRequestedCancelRefresh 
            object:nil];
    
    return self;
}

- (void)dealloc
{
    [_feedManager release];
    [_XMLFileManager release];
    
    [super dealloc];
}

//--------------------------------------------------------------//
#pragma mark -- Controllers --
//--------------------------------------------------------------//

- (SRSDFeedManager*)feedManager
{
    if (!_feedManager) {
        _feedManager = [[SRSDFeedManager alloc] initWithAppController:self];
    }
    return _feedManager;
}

- (SRSDXMLFileManager*)XMLFileManager
{
    if (!_XMLFileManager) {
        _XMLFileManager = [[SRSDXMLFileManager alloc] initWithAppController:self];
    }
    return _XMLFileManager;
}

//--------------------------------------------------------------//
#pragma mark -- Termination --
//--------------------------------------------------------------//

- (void)terminate
{
    // Remove XML files
    [_XMLFileManager removeAllTmpFiles];
    
    // Terminate itself
    [NSApp terminate:self];
}

//--------------------------------------------------------------//
#pragma mark -- Application delegate --
//--------------------------------------------------------------//

- (void)applicationDidFinishLaunching:(NSNotification*)notification
{
    // If there is no specified URL, quit itself
    if (!SRSDFeedURLs) {
        NSLog(@"No specified URLs");
        [self terminate];
        return;
    }
    
    // Load feed URLs
    [[self feedManager] refreshFeedURLs:SRSDFeedURLs];
}

//--------------------------------------------------------------//
#pragma mark -- RSS syndication notification --
//--------------------------------------------------------------//

- (void)sdFeedRequestedCancelRefresh:(NSNotification*)notification
{
    // Cancel request
    [[self feedManager] cancelAllRefresh];
}

@end
