/*
SRSDRSSDocument.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import "SRXML.h"

@interface SRSDRSSDocument : NSObject
{
    SRXMLDocument*  _document;
    NSString*       _identifier;
    
    SRXMLElement*   _rdfElement;
    SRXMLElement*   _rdfChannelElement;
    SRXMLElement*   _rssElement;
    SRXMLElement*   _rssChannelElement;
    SRXMLElement*   _feedElement;
    
    NSDate*         _channelDate;
}

// Initialize
- (id)initWithContentsOfURL:(NSURL*)url options:(unsigned int)mask error:(NSError**)error;
- (id)initWithData:(NSData*)data options:(unsigned int)mask error:(NSError**)error;
- (id)initWithXMLString:(NSString*)string options:(unsigned int)mask error:(NSError**)error;

// XML document
- (SRXMLDocument*)document;

// Identifier
- (NSString*)identifier;
- (void)setIdentifier:(NSString*)identifier;

// Channel
- (NSString*)channelTitle;
- (NSString*)channelLink;
- (NSString*)channelImageURL;
- (NSDate*)channelDate;
- (void)setChannelDate:(NSDate*)date;

// Item
- (NSArray*)items;
- (unsigned int)countOfItems;
- (NSString*)itemTitleAtIndex:(unsigned int)index;
- (NSString*)itemLinkAtIndex:(unsigned int)index;
- (NSString*)itemDescriptionAtIndex:(unsigned int)index;
- (NSString*)itemCategoryAtIndex:(unsigned int)index;
- (NSDate*)itemDateAtIndex:(unsigned int)index;

- (NSString*)itemIdentifierAtIndex:(unsigned int)index;
+ (NSString*)itemIdentifierWithItemTitle:(NSString*)title andLink:(NSString*)link;
+ (NSString*)itemIdentifierWithItem:(NSDictionary*)item;
- (unsigned int)indexOfItemIdentifier:(NSString*)itemIdentifier;

- (void)addItem:(SRXMLNode*)item;
- (void)insertItem:(SRXMLNode*)item atIndex:(unsigned int)index;
- (void)removeItemAtIndex:(unsigned int)index;

// Merge
- (void)mergeItemsWithDocument:(SRSDRSSDocument*)document;

// Parse
+ (NSMutableDictionary*)parseWithContentsOfURL:(NSURL*)url options:(unsigned int)mask error:(NSError**)error;
+ (SRXMLDocument*)XMLDocumentWithChannel:(NSDictionary*)channel;

@end

#if 0
// Utility
NSString* SRSDDateStringFromString(
        NSString* dateString, 
        NSString* format);
NSDate* SRSDDateFromString(
        NSString* dateString);
#endif
