/*
SRImageTextCell.m

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRImageTextCell.h"

@implementation SRImageTextCell

- (id)init
{
    self = [super init];
    if (!self) {
        return nil;
    }
    
    [self setWraps:NO];
    
    return self;
}

- (void)dealloc
{
    [_image release];
    _image = nil;
    [super dealloc];
}

- (id)copyWithZone:(NSZone*)zone
{
    SRImageTextCell*    cell;
    cell = (SRImageTextCell *)[super copyWithZone:zone];
    cell->_image = [_image retain];
    return cell;
}

- (void)setImage:(NSImage*)image {
    if (_image != image) {
        [_image release];
        _image = [image retain];
    }
}

- (NSImage *)image {
    return _image;
}

- (void)editWithFrame:(NSRect)rect 
        inView:(NSView*)controlView 
        editor:(NSText*)textObj 
        delegate:(id)delegate 
        event:(NSEvent*)event
{
    NSRect  textFrame, imageFrame;
    NSDivideRect(rect, &imageFrame, &textFrame, 3 + [_image size].width, NSMinXEdge);
    [super editWithFrame:textFrame 
            inView:controlView 
            editor:textObj 
            delegate:delegate 
            event:event];
}

- (void)selectWithFrame:(NSRect)rect 
        inView:(NSView*)controlView 
        editor:(NSText*)textObj 
        delegate:(id)delegate 
        start:(int)selStart 
        length:(int)selLength
{
    NSRect  textFrame, imageFrame;
    NSDivideRect(rect, &imageFrame, &textFrame, 3 + [_image size].width, NSMinXEdge);
    [super selectWithFrame:textFrame 
            inView:controlView 
            editor:textObj 
            delegate:delegate 
            start:selStart 
            length:selLength];
}

- (void)drawInteriorWithFrame:(NSRect)cellFrame 
        inView:(NSView*)controlView
{
    // Calc image and text frame
    NSRect  imageFrame;
    NSRect  textFrame;
    if (_image) {
        NSDivideRect(
                cellFrame, &imageFrame, &textFrame, 3 + [_image size].width, NSMinXEdge);
    }
    else {
        imageFrame = NSZeroRect;
        textFrame = cellFrame;
    }
    
    // Draw image
    if (_image) {
        // Decide image frame
        NSSize	size;
        NSRect	frame;
        size = [_image size];
        frame.origin = imageFrame.origin;
        frame.origin.x += 3;
        frame.size = size;
        if ([controlView isFlipped]) {
            frame.origin.y += ceil((cellFrame.size.height + frame.size.height) / 2);
        }
        else {
            frame.origin.y += ceil((cellFrame.size.height - frame.size.height) / 2);
        }
        
        // Draw image
        [_image compositeToPoint:frame.origin operation:NSCompositeSourceOver];
    }
    
    // Draw text
    [super drawInteriorWithFrame:textFrame inView:controlView];
}

@end
