<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
        xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" 
        xmlns:rss="http://purl.org/rss/1.0/" 
        xmlns:content="http://purl.org/rss/1.0/modules/content/" 
        xmlns:dc="http://purl.org/dc/elements/1.1/" 
        xmlns:admin="http://webns.net/mvcb/" 
        xmlns:l="http://purl.org/rss/1.0/modules/link/" 
        xmlns:atom="http://purl.org/atom/ns#" 
        xmlns:itunes="http://www.itunes.com/DTDs/Podcast-1.0.dtd" 
        xmlns:w3catom="http://www.w3.org/2005/Atom" 
        version="1.0">
<xsl:output method="html" indent="yes" encoding="UTF-8" cdata-section-elements="item description" omit-xml-declaration="yes"/>

<!-- ========================================
      /rss
     ======================================== -->

<xsl:template match="/rss">

<html>
    <xsl:apply-templates select="channel"/>
</html>

</xsl:template>

<!-- ========================================
      /rdf:RDF
     ======================================== -->

<xsl:template match="/rdf:RDF">

<html>
<head>
    <style type="text/css">
body {
    margin: 0;
}

a {
    color: #000000;
    text-decoration: none;
}
a:visited {
    text-decoration: none;
}
a:hover {
    color: #000000;
    text-decoration: underline;
}

p {
    line-height: 130%;
}

h1#title {
    font-size: 140%;
    font-weight: normal;
    background: blue;
    padding: 12px;
}
span#titleText {
    color: white;
}

h2 {
    font-size: 100%;
}

div#subjects {
    padding: 16px;
}
div.subject {
    padding-bottom: 4px;
    border-bottom: 1px solid #dddddd;
}
span.author {
	padding-left: 1em;
	color: gray;
}
div.description {
    line-height: 130%;
}
    </style>
</head>

<body>
    <!-- For rss:channel and rss:item -->
    <xsl:apply-templates select="rss:channel"/>
    <div id="subjects">
        <xsl:apply-templates select="rss:item"/>
    </div>
    
    <!-- If there is no rss:channel, try channel -->
    <xsl:apply-templates select="channel"/>
    <div id="subjects">
        <xsl:apply-templates select="item"/>
    </div>
</body>
</html>

</xsl:template>

<!-- ========================================
      /atom:feed
     ======================================== -->

<xsl:template match="/atom:feed">

<html>
<head>
    <style type="text/css">
body {
    margin: 0;
}

a {
    color: #000000;
    text-decoration: none;
}
a:visited {
    text-decoration: none;
}
a:hover {
    color: #000000;
    text-decoration: underline;
}

p {
    line-height: 130%;
}

h1#title {
    font-size: 140%;
    font-weight: normal;
    background: blue;
    padding: 12px;
}
span#titleText {
    color: white;
}

h2 {
    font-size: 100%;
}

div#subjects {
    padding: 16px;
}
div.subject {
    padding-bottom: 4px;
    border-bottom: 1px solid #dddddd;
}
span.author {
	padding-left: 1em;
	color: gray;
}
div.description {
    line-height: 130%;
}
    </style>
    <title><xsl:value-of select="title"/></title>
</head>

<body>
    <h1 id="title">
        <a>
            <xsl:attribute name="href"><xsl:value-of select="atom:link/@href"/></xsl:attribute>
            <span id="titleText"><xsl:value-of select="atom:title" disable-output-escaping="yes"/></span>
        </a>
    </h1>
    
    <div id="subjects">
        <xsl:apply-templates select="atom:entry"/>
    </div>
</body>
</html>

</xsl:template>

<!-- ========================================
      /w3catom:feed
     ======================================== -->

<xsl:template match="/w3catom:feed">

<html>
<head>
    <style type="text/css">
body {
    margin: 0;
}

a {
    color: #000000;
    text-decoration: none;
}
a:visited {
    text-decoration: none;
}
a:hover {
    color: #000000;
    text-decoration: underline;
}

p {
    line-height: 130%;
}

h1#title {
    font-size: 140%;
    font-weight: normal;
    background: blue;
    padding: 12px;
}
span#titleText {
    color: white;
}

h2 {
    font-size: 100%;
}

div#subjects {
    padding: 16px;
}
div.subject {
    padding-bottom: 4px;
    border-bottom: 1px solid #dddddd;
}
span.author {
	padding-left: 1em;
	color: gray;
}
div.description {
    line-height: 130%;
}
    </style>
    <title><xsl:value-of select="title"/></title>
</head>

<body>
    <h1 id="title">
        <a>
            <xsl:attribute name="href"><xsl:value-of select="w3catom:link/@href"/></xsl:attribute>
            <span id="titleText"><xsl:value-of select="w3catom:title" disable-output-escaping="yes"/></span>
        </a>
    </h1>
    
    <div id="subjects">
        <xsl:apply-templates select="w3catom:entry"/>
    </div>
</body>
</html>

</xsl:template>

<!-- ========================================
      channel
     ======================================== -->

<xsl:template match="channel">

<head>
    <style type="text/css">
body {
    margin: 0;
}

a {
    color: #000000;
    text-decoration: none;
}
a:visited {
    text-decoration: none;
}
a:hover {
    color: #000000;
    text-decoration: underline;
}

p {
    line-height: 130%;
}

h1#title {
    font-size: 140%;
    font-weight: normal;
    background: blue;
    padding: 12px;
}
span#titleText {
    color: white;
}

h2 {
    font-size: 100%;
}

div#subjects {
    padding: 16px;
}
div.subject {
    padding-bottom: 4px;
    border-bottom: 1px solid #dddddd;
}
span.author {
	padding-left: 1em;
	color: gray;
}
div.description {
    line-height: 130%;
}
    </style>
    <title><xsl:value-of select="title"/></title>
</head>

<body>
    <h1 id="title">
        <a>
            <xsl:attribute name="href"><xsl:value-of select="link"/></xsl:attribute>
            <span id="titleText"><xsl:value-of select="title" disable-output-escaping="yes"/></span>
        </a>
    </h1>
    
    <div id="subjects">
        <xsl:apply-templates select="item"/>
    </div>
</body>

</xsl:template>

<!-- ========================================
      rss:channel
     ======================================== -->

<xsl:template match="rss:channel">

<h1 id="title">
    <a>
        <xsl:attribute name="href"><xsl:value-of select="rss:link"/></xsl:attribute>
        <span id="titleText"><xsl:value-of select="rss:title" disable-output-escaping="yes"/></span>
    </a>
</h1>

</xsl:template>

<!-- ========================================
      item
     ======================================== -->

<xsl:template match="item">
<div class="subject">
    <h2>
        <a>
            <xsl:attribute name="href"><xsl:value-of select="link"/></xsl:attribute>
            <span class="subjectTitle"><xsl:value-of select="title" disable-output-escaping="yes"/></span>
        </a>
		<span class="author"><xsl:value-of select="author"/></span>
    </h2>
    <div class="description"><xsl:value-of select="description" disable-output-escaping="yes"/></div>
</div>
</xsl:template>

<!-- ========================================
      rss:item
     ======================================== -->

<xsl:template match="rss:item">
<div class="subject">
    <h2>
        <a>
            <xsl:attribute name="href"><xsl:value-of select="rss:link"/></xsl:attribute>
            <span class="subjectTitle"><xsl:value-of select="rss:title" disable-output-escaping="yes"/></span>
        </a>
		<span class="author"><xsl:value-of select="author"/></span>
    </h2>
    <div class="description"><xsl:value-of select="rss:description" disable-output-escaping="yes"/></div>
</div>
</xsl:template>

<!-- ========================================
      atom:entry
     ======================================== -->

<xsl:template match="atom:entry">
<div class="subject">
    <h2>
        <a>
            <xsl:attribute name="href"><xsl:value-of select="atom:link/@href"/></xsl:attribute>
            <span class="subjectTitle"><xsl:value-of select="atom:title" disable-output-escaping="yes"/></span>
        </a>
		<a>
			<xsl:attribute name="href"><xsl:value-of select="atom:author/atom:url"/></xsl:attribute>
			<span class="author"><xsl:value-of select="atom:author/atom:name"/></span>
		</a>
    </h2>
    <div class="description"><xsl:value-of select="atom:summary" disable-output-escaping="yes"/></div>
</div>
</xsl:template>

<!-- ========================================
      w3catom:entry
     ======================================== -->

<xsl:template match="w3catom:entry">
<div class="subject">
    <h2>
        <a>
            <xsl:attribute name="href"><xsl:value-of select="w3catom:link/@href"/></xsl:attribute>
            <span class="subjectTitle"><xsl:value-of select="w3catom:title" disable-output-escaping="yes"/></span>
        </a>
		<a>
			<xsl:attribute name="href"><xsl:value-of select="w3catom:author/w3catom:url"/></xsl:attribute>
			<span class="author"><xsl:value-of select="w3catom:author/w3catom:name"/></span>
		</a>
    </h2>
    <div class="description"><xsl:value-of select="w3catom:summary" disable-output-escaping="yes"/></div>
</div>
</xsl:template>

</xsl:stylesheet>
