/*
 * Decompiled with CFR 0.152.
 */
package shohaku.kosho;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import shohaku.core.collections.IteratorUtils;
import shohaku.ginkgo.Ginkgo;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.NodeCompositeRule;
import shohaku.kosho.Kosho;
import shohaku.kosho.KoshoResources;
import shohaku.kosho.KoshoResourcesLoader;

public class ClassBindConfiguration
implements KoshoResources,
KoshoResourcesLoader {
    private final Map lookup = new Hashtable();
    static /* synthetic */ Class class$0;

    public void load(InputStream inStream) throws GinkgoException {
        this.load(inStream, ClassBindConfiguration.getDefaultNodeCompositeRule());
    }

    public void load(InputStream inStream, NodeCompositeRule rule) throws GinkgoException {
        Ginkgo ginkgo = new Ginkgo();
        ginkgo.parse(rule, inStream);
        Node root = ginkgo.getDocument().getContext().getRoot();
        this.initValues(root);
    }

    private void initValues(Node root) {
        HashMap m = new HashMap();
        this.initValues(root, "", m, '.');
        this.lookup.putAll(m);
    }

    private void initValues(Node parent, String parentName, Map m, char separator) {
        Iterator iter = parent.getContext().ownerIterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            this.initValue(node, parentName, m, separator);
        }
    }

    private void initValue(Node node, String parentName, Map m, char separator) {
        if (node.isType(3)) {
            String name = node.getAttribute("name");
            if (name != null && name.length() != 0) {
                m.put(String.valueOf(parentName) + name, node.getNodeValue());
            }
        } else if (node.isType(1)) {
            if ("constants".equals(node.getContext().getNodeName())) {
                this.initValues(node, parentName, m, '_');
            } else {
                String name = node.getAttribute("name");
                if (name != null && name.length() != 0) {
                    this.initValues(node, String.valueOf(parentName) + name + separator, m, separator);
                }
            }
        }
    }

    public Iterator keyIterator() {
        return IteratorUtils.unmodifiableIterator(this.lookup.keySet().iterator());
    }

    public Object getObject(String key) {
        if (key == null) {
            throw new NullPointerException("resource key as null");
        }
        Object obj = this.lookup.get(key);
        return obj;
    }

    public Object getObject(String key, Object defaultValue) {
        Object o = this.getObject(key);
        if (o == null) {
            o = defaultValue;
        }
        return o;
    }

    public boolean containsKey(String key) {
        if (key == null) {
            throw new NullPointerException("resource key as null");
        }
        return this.lookup.containsKey(key);
    }

    public boolean containsKey(String key, Class type) {
        if (key == null || type == null) {
            throw new NullPointerException("resource key or type as null");
        }
        Object o = this.getObject(key);
        if (o != null) {
            return type.isInstance(o);
        }
        return this.containsKey(key);
    }

    public static NodeCompositeRule getDefaultNodeCompositeRule() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("shohaku.kosho.ClassBindConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return Kosho.getDefaultNodeCompositeRule(clazz);
    }
}

